<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * TRANSFERT
 *  - PRESTATAIRES      =>     SIEGE                (Reconversion)
 *
 * @ORM\Entity()
 */
class TransfertPrestataireSiege extends Transfert
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Siege")
     * @ORM\JoinColumn(name="siege_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @var boolean
     * @Assert\Type("bool")
     * @ORM\Column(type="boolean")
     */
    protected $reconverti = false;

    public function __construct()
    {
        parent::__construct();
        $this->reconverti = false;
    }

    public function getReconverti(): bool
    {
        return $this->reconverti;
    }

    public function setReconverti(bool $reconverti)
    {
        $this->reconverti = $reconverti;
        return $this;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'prestataire_siege'; //reconversion
    }
}
