<?php

namespace App\Security\Voter;

use App\Entity\User;
use App\Security\Voter\AbstractVoter;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\AccessDecisionManagerInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class UserVoter extends AbstractVoter
{
    protected function supports($attribute, $subject)
    {
        // Est-ce que l'action demandée existe
        if (!parent::supportsAttribute($attribute)) {
            return false;
        }

        // On ne vote que pour des objets de type User
        if (!$subject instanceof User) {
            return false;
        }

        return true;
    }

    protected function voteOnAttribute($attribute, $subject, TokenInterface $token)
    {
        $user = $token->getUser();

        if (!$user instanceof User) {
            // L'utilisateur doit être loggué
            return false;
        }

        // Les admins peuvent tout faire !
        if ($this->decisionManager->decide($token, array('ROLE_SUPER_ADMIN', 'ROLE_ADMIN', 'ROLE_ADMIN_SIEGE'))) {
            return true;
        }

        switch ($attribute) {
            case self::LIST:
                return $this->canList($subject, $user);
            case self::VIEW:
                return $this->canView($subject, $user);
            case self::CREATE:
                return $this->canCreate($subject, $user);
            case self::EDIT:
                return $this->canEdit($subject, $user);
            case self::DELETE:
                return $this->canDelete($subject, $user);
            case self::EXPORT:
                return $this->canExport($subject, $user);
            case self::ALL:
                return $this->canAll($subject, $user);
        }

        throw new \LogicException('This code should not be reached!');
    }

    private function canList(User $subject, User $user)
    {
        // Only ADMIN can list users so already return true before
        return false;
    }

    private function canView(User $subject, User $user)
    {
        // if ($this->decisionManager->decide($token, array('ROLE_ADHERENT'))) {
    }

    private function canCreate(User $subject, User $user)
    {
    }

    private function canEdit(User $subject, User $user)
    {
    }

    private function canDelete(User $subject, User $user)
    {
    }

    private function canExport(User $subject, User $user)
    {
    }

    private function canAll(User $subject, User $user)
    {
    }
}
