<?php declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20181130175453 extends AbstractMigration
{
    public function up(Schema $schema) : void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE amap_prestataire DROP FOREIGN KEY FK_2B4E626652AA66E8');
        $this->addSql('ALTER TABLE marche_prestataire DROP FOREIGN KEY FK_652F05189E494911');
        $this->addSql('CREATE TABLE groupeprestaire (id INT AUTO_INCREMENT NOT NULL, geoloc_id INT DEFAULT NULL, type VARCHAR(20) NOT NULL, horaires VARCHAR(200) NOT NULL, name VARCHAR(150) NOT NULL, slug VARCHAR(150) NOT NULL, content LONGTEXT DEFAULT NULL, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, tel VARCHAR(20) DEFAULT NULL, email VARCHAR(100) DEFAULT NULL, enabled TINYINT(1) NOT NULL, UNIQUE INDEX UNIQ_FB9ABBCE989D9B62 (slug), UNIQUE INDEX UNIQ_FB9ABBCEEF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE groupeprestataire_prestataire (groupeprestataire_id INT NOT NULL, prestataire_id INT NOT NULL, INDEX IDX_66D8DEC98D18A702 (groupeprestataire_id), INDEX IDX_66D8DEC9BE3DB2B7 (prestataire_id), PRIMARY KEY(groupeprestataire_id, prestataire_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE groupeprestaire ADD CONSTRAINT FK_FB9ABBCEEF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE groupeprestataire_prestataire ADD CONSTRAINT FK_66D8DEC98D18A702 FOREIGN KEY (groupeprestataire_id) REFERENCES groupeprestaire (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE groupeprestataire_prestataire ADD CONSTRAINT FK_66D8DEC9BE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id) ON DELETE CASCADE');
        $this->addSql('DROP TABLE amap');
        $this->addSql('DROP TABLE amap_prestataire');
        $this->addSql('DROP TABLE marche');
        $this->addSql('DROP TABLE marche_prestataire');
        $this->addSql('ALTER TABLE news CHANGE fichier_id fichier_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE document CHANGE fichier_id fichier_id INT DEFAULT NULL, CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE transaction CHANGE expediteur_id expediteur_id INT DEFAULT NULL, CHANGE destinataire_id destinataire_id INT DEFAULT NULL, CHANGE titre titre VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE adherent CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE comptoir CHANGE fichier_id fichier_id INT DEFAULT NULL, CHANGE groupe_id groupe_id INT DEFAULT NULL, CHANGE geoloc_id geoloc_id INT DEFAULT NULL, CHANGE tel tel VARCHAR(20) DEFAULT NULL, CHANGE email email VARCHAR(100) DEFAULT NULL');
        $this->addSql('ALTER TABLE user CHANGE user_id user_id INT DEFAULT NULL, CHANGE adherent adherent INT DEFAULT NULL, CHANGE prestataire prestataire INT DEFAULT NULL, CHANGE salt salt VARCHAR(255) DEFAULT NULL, CHANGE last_login last_login DATETIME DEFAULT NULL, CHANGE confirmation_token confirmation_token VARCHAR(180) DEFAULT NULL, CHANGE password_requested_at password_requested_at DATETIME DEFAULT NULL, CHANGE date_of_birth date_of_birth DATETIME DEFAULT NULL, CHANGE firstname firstname VARCHAR(64) DEFAULT NULL, CHANGE lastname lastname VARCHAR(64) DEFAULT NULL, CHANGE website website VARCHAR(64) DEFAULT NULL, CHANGE biography biography VARCHAR(1000) DEFAULT NULL, CHANGE gender gender VARCHAR(1) DEFAULT NULL, CHANGE locale locale VARCHAR(8) DEFAULT NULL, CHANGE timezone timezone VARCHAR(64) DEFAULT NULL, CHANGE phone phone VARCHAR(64) DEFAULT NULL, CHANGE facebook_uid facebook_uid VARCHAR(255) DEFAULT NULL, CHANGE facebook_name facebook_name VARCHAR(255) DEFAULT NULL, CHANGE facebook_data facebook_data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\', CHANGE twitter_uid twitter_uid VARCHAR(255) DEFAULT NULL, CHANGE twitter_name twitter_name VARCHAR(255) DEFAULT NULL, CHANGE twitter_data twitter_data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\', CHANGE gplus_uid gplus_uid VARCHAR(255) DEFAULT NULL, CHANGE gplus_name gplus_name VARCHAR(255) DEFAULT NULL, CHANGE gplus_data gplus_data LONGTEXT DEFAULT NULL COMMENT \'(DC2Type:json)\', CHANGE token token VARCHAR(255) DEFAULT NULL, CHANGE two_step_code two_step_code VARCHAR(255) DEFAULT NULL, CHANGE etat etat VARCHAR(10) DEFAULT NULL, CHANGE mobile mobile VARCHAR(15) DEFAULT NULL');
        $this->addSql('ALTER TABLE charte CHANGE image_id image_id INT DEFAULT NULL, CHANGE fichier_id fichier_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE transfert CHANGE reference reference VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE lien CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE prestataire CHANGE typeprestataire_id typeprestataire_id INT DEFAULT NULL, CHANGE image_id image_id INT DEFAULT NULL, CHANGE user_id user_id INT DEFAULT NULL, CHANGE prestataire_group_id prestataire_group_id INT DEFAULT NULL, CHANGE geoloc_id geoloc_id INT DEFAULT NULL, CHANGE statut statut VARCHAR(50) DEFAULT NULL, CHANGE responsable responsable VARCHAR(200) DEFAULT NULL, CHANGE web web VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE geoloc CHANGE adresse adresse VARCHAR(255) DEFAULT NULL, CHANGE cpostal cpostal INT DEFAULT NULL, CHANGE ville ville VARCHAR(100) DEFAULT NULL, CHANGE lat lat NUMERIC(10, 8) DEFAULT NULL, CHANGE lon lon NUMERIC(10, 8) DEFAULT NULL');
        $this->addSql('ALTER TABLE faq CHANGE fichier_id fichier_id INT DEFAULT NULL, CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE page CHANGE description description VARCHAR(255) DEFAULT NULL, CHANGE tag tag VARCHAR(255) DEFAULT NULL, CHANGE template template VARCHAR(255) DEFAULT NULL');
        $this->addSql('ALTER TABLE message CHANGE expediteur_id expediteur_id INT DEFAULT NULL, CHANGE destinataire_id destinataire_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE fichier CHANGE width width INT DEFAULT NULL, CHANGE height height INT DEFAULT NULL');
    }

    public function down(Schema $schema) : void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

        $this->addSql('ALTER TABLE groupeprestataire_prestataire DROP FOREIGN KEY FK_66D8DEC98D18A702');
        $this->addSql('CREATE TABLE amap (id INT AUTO_INCREMENT NOT NULL, geoloc_id INT DEFAULT NULL, name VARCHAR(150) NOT NULL COLLATE utf8mb4_unicode_ci, slug VARCHAR(150) NOT NULL COLLATE utf8mb4_unicode_ci, content LONGTEXT DEFAULT NULL COLLATE utf8mb4_unicode_ci, created_at DATETIME NOT NULL, updated_at DATETIME NOT NULL, tel VARCHAR(20) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, email VARCHAR(100) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, enabled TINYINT(1) NOT NULL, UNIQUE INDEX UNIQ_CE323CD3989D9B62 (slug), UNIQUE INDEX UNIQ_CE323CD3EF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE amap_prestataire (amap_id INT NOT NULL, prestataire_id INT NOT NULL, INDEX IDX_2B4E626652AA66E8 (amap_id), INDEX IDX_2B4E6266BE3DB2B7 (prestataire_id), PRIMARY KEY(amap_id, prestataire_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE marche (id INT AUTO_INCREMENT NOT NULL, geoloc_id INT DEFAULT NULL, contact VARCHAR(100) NOT NULL COLLATE utf8mb4_unicode_ci, jour VARCHAR(255) NOT NULL COLLATE utf8mb4_unicode_ci, name VARCHAR(150) NOT NULL COLLATE utf8mb4_unicode_ci, slug VARCHAR(150) NOT NULL COLLATE utf8mb4_unicode_ci, content LONGTEXT DEFAULT NULL COLLATE utf8mb4_unicode_ci, enabled TINYINT(1) NOT NULL, tel VARCHAR(20) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, email VARCHAR(100) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, UNIQUE INDEX UNIQ_BAA18ACC989D9B62 (slug), UNIQUE INDEX UNIQ_BAA18ACCEF390162 (geoloc_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('CREATE TABLE marche_prestataire (marche_id INT NOT NULL, prestataire_id INT NOT NULL, INDEX IDX_652F05189E494911 (marche_id), INDEX IDX_652F0518BE3DB2B7 (prestataire_id), PRIMARY KEY(marche_id, prestataire_id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB');
        $this->addSql('ALTER TABLE amap ADD CONSTRAINT FK_CE323CD3EF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE amap_prestataire ADD CONSTRAINT FK_2B4E626652AA66E8 FOREIGN KEY (amap_id) REFERENCES amap (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE amap_prestataire ADD CONSTRAINT FK_2B4E6266BE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE marche ADD CONSTRAINT FK_BAA18ACCEF390162 FOREIGN KEY (geoloc_id) REFERENCES geoloc (id)');
        $this->addSql('ALTER TABLE marche_prestataire ADD CONSTRAINT FK_652F05189E494911 FOREIGN KEY (marche_id) REFERENCES marche (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE marche_prestataire ADD CONSTRAINT FK_652F0518BE3DB2B7 FOREIGN KEY (prestataire_id) REFERENCES prestataire (id) ON DELETE CASCADE');
        $this->addSql('DROP TABLE groupeprestaire');
        $this->addSql('DROP TABLE groupeprestataire_prestataire');
        $this->addSql('ALTER TABLE adherent CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE charte CHANGE image_id image_id INT DEFAULT NULL, CHANGE fichier_id fichier_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE comptoir CHANGE fichier_id fichier_id INT DEFAULT NULL, CHANGE groupe_id groupe_id INT DEFAULT NULL, CHANGE geoloc_id geoloc_id INT DEFAULT NULL, CHANGE tel tel VARCHAR(20) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE email email VARCHAR(100) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE document CHANGE fichier_id fichier_id INT DEFAULT NULL, CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE faq CHANGE fichier_id fichier_id INT DEFAULT NULL, CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE fichier CHANGE width width INT DEFAULT NULL, CHANGE height height INT DEFAULT NULL');
        $this->addSql('ALTER TABLE geoloc CHANGE adresse adresse VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE cpostal cpostal INT DEFAULT NULL, CHANGE ville ville VARCHAR(100) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE lat lat NUMERIC(10, 8) DEFAULT \'NULL\', CHANGE lon lon NUMERIC(10, 8) DEFAULT \'NULL\'');
        $this->addSql('ALTER TABLE lien CHANGE user_id user_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE message CHANGE expediteur_id expediteur_id INT DEFAULT NULL, CHANGE destinataire_id destinataire_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE news CHANGE fichier_id fichier_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE page CHANGE description description VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE tag tag VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE template template VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE prestataire CHANGE typeprestataire_id typeprestataire_id INT DEFAULT NULL, CHANGE image_id image_id INT DEFAULT NULL, CHANGE user_id user_id INT DEFAULT NULL, CHANGE prestataire_group_id prestataire_group_id INT DEFAULT NULL, CHANGE geoloc_id geoloc_id INT DEFAULT NULL, CHANGE statut statut VARCHAR(50) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE responsable responsable VARCHAR(200) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE web web VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE transaction CHANGE expediteur_id expediteur_id INT DEFAULT NULL, CHANGE destinataire_id destinataire_id INT DEFAULT NULL, CHANGE titre titre VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE transfert CHANGE reference reference VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
        $this->addSql('ALTER TABLE user CHANGE user_id user_id INT DEFAULT NULL, CHANGE adherent adherent INT DEFAULT NULL, CHANGE prestataire prestataire INT DEFAULT NULL, CHANGE salt salt VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE last_login last_login DATETIME DEFAULT \'NULL\', CHANGE confirmation_token confirmation_token VARCHAR(180) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE password_requested_at password_requested_at DATETIME DEFAULT \'NULL\', CHANGE date_of_birth date_of_birth DATETIME DEFAULT \'NULL\', CHANGE firstname firstname VARCHAR(64) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE lastname lastname VARCHAR(64) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE website website VARCHAR(64) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE biography biography VARCHAR(1000) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE gender gender VARCHAR(1) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE locale locale VARCHAR(8) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE timezone timezone VARCHAR(64) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE phone phone VARCHAR(64) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE facebook_uid facebook_uid VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE facebook_name facebook_name VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE facebook_data facebook_data LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:json)\', CHANGE twitter_uid twitter_uid VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE twitter_name twitter_name VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE twitter_data twitter_data LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:json)\', CHANGE gplus_uid gplus_uid VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE gplus_name gplus_name VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE gplus_data gplus_data LONGTEXT DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci COMMENT \'(DC2Type:json)\', CHANGE token token VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE two_step_code two_step_code VARCHAR(255) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE etat etat VARCHAR(10) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci, CHANGE mobile mobile VARCHAR(15) DEFAULT \'NULL\' COLLATE utf8mb4_unicode_ci');
    }
}
