<?php
namespace App\EventListener;

use App\Entity\Adherent;
use App\Entity\EntityTrait\GeolocEntityTrait;
use App\Entity\Prestataire;
use App\Entity\User;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Geocoder\Provider\Nominatim\Nominatim;
use Geocoder\Query\GeocodeQuery;

class UserListener
{
    public function preUpdate(PreUpdateEventArgs $eventArgs)
    {
        $entity = $eventArgs->getEntity();

        if (!($entity instanceof User) && !empty($user->getUsername())) {
            return;
        }
        // GEOCODING ADDRESS :
        $httpClient = new \Http\Adapter\Guzzle6\Client();
        $provider = Nominatim::withOpenStreetMapServer($httpClient, 'test');
        $geocoder = new \Geocoder\StatefulGeocoder($provider, 'fr');
        $fullAddress = $entity->getAdresse().' '.$entity->getCpostal().' '.$entity->getVille();
        // Query geocoding from complete addresse
        $result = $geocoder->geocodeQuery(GeocodeQuery::create($fullAddress));
        if (count($result) > 0) {
            $coords = $result->first()->getCoordinates();
            $entity->setLat($coords->getLatitude());
            $entity->setLon($coords->getLongitude());
        }
    }
}
