<?php

namespace App\Enum;

abstract class MoyenEnum
{
    const MOYEN_CB       = "cb";
    const MOYEN_ESPECE   = "espece";
    const MOYEN_CHEQUE   = "cheque";
    const MOYEN_VIREMENT = "virement";
    const MOYEN_AUTRE    = "autre";

    /** @var array user friendly named type */
    protected static $typeName = [
        self::MOYEN_CB    => 'Carte bancaire',
        self::MOYEN_ESPECE => 'Espèce',
        self::MOYEN_CHEQUE => 'Chèque',
        self::MOYEN_VIREMENT  => 'Virement',
        self::MOYEN_AUTRE  => 'Autre',
    ];

    /**
     * @param  string $typeShortName
     * @return string
     */
    public static function getTypeName($typeShortName)
    {
        if (!isset(static::$typeName[$typeShortName])) {
            return "Unknown type ($typeShortName)";
        }

        return static::$typeName[$typeShortName];
    }

    /**
     * @return array<string>
     */
    public static function getAvailableTypes()
    {
        return [
            self::MOYEN_CB,
            self::MOYEN_ESPECE,
            self::MOYEN_CHEQUE,
            self::MOYEN_VIREMENT,
            self::MOYEN_AUTRE
        ];
    }
}
