<?php

namespace App\Entity;

use App\Entity\Comptoir;
use App\Entity\Groupe;
use App\Entity\Transfert;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSFERT
 *  - COMPTOIRS         =>     GROUPES LOCAUX           (Transfert du comptoir au groupe)
 *
 * @ORM\Entity()
 */
class TransfertComptoirGroupe extends Transfert
{
    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Groupe")
     * @ORM\JoinColumn(name="groupe_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'comptoir_groupe';
    }
}
