<?php

namespace App\Entity;

use App\Entity\Adherent;
use App\Entity\Prestataire;
use App\Entity\Transaction;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *   - PRESTATAIRES     =>    PRESTATAIRES      (Virement entre prestataires)
 *
 * @ORM\Entity
 */
class TransactionPrestatairePrestataire extends Transaction
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_dest_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'prestataire_prestataire';
    }
}
