<?php

namespace App\Entity;

use App\Entity\Adherent;
use App\Entity\Prestataire;
use App\Entity\Transaction;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *   - PRESTATAIRES     =>    ADHERENTS         (Virement vers un adherent)
 *
 * @ORM\Entity
 */
class TransactionPrestataireAdherent extends Transaction
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Adherent")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'prestataire_adherent';
    }
}
