<?php

namespace App\Entity;

use App\Entity\Adherent;
use App\Entity\Prestataire;
use App\Entity\Transaction;
use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSACTION
 *   - ADHERENTS        =>    PRESTATAIRES      (Paiement numérique)
 *
 * @ORM\Entity
 */
class TransactionAdherentPrestataire extends Transaction
{
    /**
     * @ORM\OneToOne(targetEntity="Adherent")
     * @ORM\JoinColumn(name="adherent_id", referencedColumnName="id", nullable=true)
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id", nullable=true)
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'adherent_prestataire';
    }
}
