<?php

namespace App\Entity;

use App\Entity\Comptoir;
use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\HasCompteEntity;
use App\Entity\EntityTrait\NameSlugContentEntityTrait;
use App\Entity\Prestataire;
use App\Entity\Siege;
use App\Entity\User;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Gedmo\Timestampable\Traits\TimestampableEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="groupe")
 */
class Groupe
{
    use NameSlugContentEntityTrait,
        TimestampableEntity,
        EnablableEntityTrait;

    /**
     * @var int
     *
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    protected $id;

    /**
     * @var Siege
     *
     * @ORM\ManyToOne(targetEntity="Siege", inversedBy="groupes")
     * @ORM\JoinColumn(name="siege_id", referencedColumnName="id", nullable=false)
     */
    private $siege;

    /**
     * @var ArrayCollection|Comptoir[]
     * @ORM\OneToMany(targetEntity="Comptoir", mappedBy="groupe", fetch="EXTRA_LAZY")
     * @ORM\OrderBy({"name": "ASC"})
     */
    private $comptoirs;

    /**
     * @var ArrayCollection|Prestataire[]
     * @ORM\OneToMany(targetEntity="Prestataire", mappedBy="prestataireGroup", fetch="EXTRA_LAZY")
     * @ORM\OrderBy({"raison": "ASC"})
     */
    private $prestataires;

    public function __construct()
    {
        $this->comptoirs = new ArrayCollection();
        $this->prestataires = new ArrayCollection();
    }

    /**
    * Get siege
    * @return Siege
    */
    public function getSiege()
    {
        return $this->siege;
    }

    /**
    * Set siege
    * @return $this
    */
    public function setSiege($siege)
    {
        $this->siege = $siege;
        return $this;
    }

    /**
     * @return int
     */
    public function getId(): int
    {
        return $this->id;
    }

    /**
     * Set id
     * @param string $id [description]
     */
    public function setId(string $id): self
    {
        $this->id = $id;
        return $this;
    }

    /**
     * @return Comptoir[]|ArrayCollection
     */
    public function getComptoirs()
    {
        return $this->comptoirs;
    }

    /**
     * @param Comptoir $comptoir
     * @return $this
     */
    public function addComptoir(Comptoir $comptoir)
    {
        if (!$this->comptoirs->contains($comptoir)) {
            $this->comptoirs[] = $comptoir;
            $comptoir->setGroupe($this);
        }
        return $this;
    }

    /**
     * @param Comptoir $comptoir
     * @return $this
     */
    public function removeComptoir(Comptoir $comptoir)
    {
        if ($this->comptoirs->contains($comptoir)) {
            $this->comptoirs->removeElement($comptoir);
            $comptoir->setGroupe(null);
        }
        return $this;
    }

    /**
     * @return Prestataire[]|ArrayCollection
     */
    public function getPrestataires()
    {
        return $this->prestataires;
    }

    /**
     * @param Prestataire $prestataire
     * @return $this
     */
    public function addPrestataire(Prestataire $prestataire)
    {
        if (!$this->prestataires->contains($prestataire)) {
            $this->prestataires[] = $prestataire;
            $prestataire->setPrestataireGroup($this);
        }
        return $this;
    }

    /**
     * @param Prestataire $prestataire
     * @return $this
     */
    public function removePrestataire(Prestataire $prestataire)
    {
        if ($this->prestataires->contains($prestataire)) {
            $this->prestataires->removeElement($prestataire);
            $prestataire->setPrestataireGroup(null);
        }
        return $this;
    }

    public function getComptoirsCount()
    {
        return $this->getComptoirs()->count();
    }

    public function getPrestatairesCount()
    {
        return $this->getPrestataires()->count();
    }

    public function __toString(): string
    {
        return (!empty($this->getName())?$this->getName():'Groupe');
    }
}
