<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Symfony\Component\HttpFoundation\File\File;
use Symfony\Component\Validator\Constraints as Assert;
use Vich\UploaderBundle\Mapping\Annotation as Vich;

/**
 * @ORM\Entity(repositoryClass="App\Repository\GlobalConfigurationRepository")
 */
class GlobalConfiguration
{
    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $mlcname;

    /**
     * @ORM\Column(type="string", length=50)
     */
    private $mlcsmallname;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $charte;

    /**
     * @Assert\Image(maxSize="2M", minWidth="50", minHeight="50")
     * @Vich\UploadableField(mapping="logo", fileNameProperty="path")
     * @Assert\File(maxSize="2M", mimeTypes={"image/*"})
     */
    protected $logo;

    /**
     * @var string
     *
     * @ORM\Column(name="pathlogo", type="text", nullable=true)
     */
    private $pathlogo;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMlcname(): ?string
    {
        return $this->mlcname;
    }

    public function setMlcname(string $mlcname): self
    {
        $this->mlcname = $mlcname;

        return $this;
    }

    public function getMlcsmallname(): ?string
    {
        return $this->mlcsmallname;
    }

    public function setMlcsmallname(string $mlcsmallname): self
    {
        $this->mlcsmallname = $mlcsmallname;

        return $this;
    }

    public function getCharte(): ?string
    {
        return $this->charte;
    }

    public function setCharte(?string $charte): self
    {
        $this->charte = $charte;

        return $this;
    }

    /**
     * If manually uploading a file (i.e. not using Symfony Form) ensure an instance
     * of 'UploadedFile' is injected into this setter to trigger the  update. If this
     * bundle's configuration parameter 'inject_on_load' is set to 'true' this setter
     * must be able to accept an instance of 'File' as the bundle will inject one here
     * during Doctrine hydration.
     *
     * @param File|\Symfony\Component\HttpFoundation\File\UploadedFile $image
     */
    public function setLogo(File $image = null)
    {
        $this->logo = $image;
        if ($image) {
            // It is required that at least one field changes if you are using doctrine
            // otherwise the event listeners won't be called and the file is lost
            $this->updated = new \DateTimeImmutable();
        }
    }

    public function getLogo()
    {
        return $this->logo;
    }

    /**
     * Set path
     *
     * @param string $path
     * @return Photo
     */
    public function setPathLogo($path)
    {
        $this->pathlogo = $path;

        return $this;
    }

    /**
     * Get path
     *
     * @return string
     */
    public function getPathLogo()
    {
        return $this->pathlogo;
    }
}
