<?php

namespace App\Entity;

use App\Entity\EntityTrait\EnablableEntityTrait;
use App\Entity\EntityTrait\GeolocEntityTrait;
use App\Entity\User;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="App\Repository\AdherentRepository")
 */
class Adherent
{
    use EnablableEntityTrait,
        GeolocEntityTrait;

    /**
     * @ORM\Id()
     * @ORM\GeneratedValue()
     * @ORM\Column(type="integer")
     */
    private $id;

    /**
     * @ORM\Column(type="decimal", precision=7, scale=2)
     */
    private $ecompte;

    /**
     * @var User
     *
     * @ORM\OneToOne(targetEntity="User", cascade={"all"}, mappedBy="adherent", fetch="EAGER")
     */
    protected $user;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getEcompte()
    {
        return $this->ecompte;
    }

    public function setEcompte($ecompte): self
    {
        $this->ecompte = $ecompte;

        return $this;
    }

    /**
     * @return User
     */
    public function getUser(): ?User
    {
        return $this->user;
    }

    /**
     * @param User $user
     * @return Prestataire
     */
    public function setUser(User $user): self
    {
        $this->user = $user;
        return $this;
    }

    public function isEnabled(): bool
    {
        return $this->getUser()->isEnabled();
    }

    public function setEnabled($enabled): self
    {
        $this->getUser()->setEnabled($enabled);
        return $this;
    }

    public function __toString(): string
    {
        return (!empty($this->getUser() && $this->getUser()->getUsername())?$this->getUser()->getUsername():'Adherent '.$this->getId());
    }
}
