<?php

namespace App\Admin;

use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;

class GroupeprestataireAdmin extends AbstractAdmin
{
    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'updatedAt',
    ];

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $groupepresta = $this->getSubject();
        $formMapper
            ->add('name', TextType::class, array(
                'label' => 'Nom du groupe :',
                'required' => true
            ))
            ->add('content', CKEditorType::class, array(
                'label' => 'Texte',
                'required' => false,
            ))
            ->add('horaires', TextareaType::class, array(
                'label' => 'Horaires :',
                'required' => false
            ))
            ->add('enabled', CheckboxType::class, array(
                'label' => 'Activé ?',
                'required' => false,
                'label_attr' => array('class' => 'checkbox-inline')
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array(
                'label' => 'Nom du groupe'
            ))
            ->addIdentifier('horaires', 'html', array(
                'label' => 'Horaires',
                'strip' => true,
                'truncate' => 50
            ))
            ->add(
                'getPrestatairesCount',
                null,
                [
                    'sortable' => true,
                    'sort_field_mapping' => ['fieldName' => 'id'],
                    'sort_parent_association_mappings' => [],
                ]
            )
            ->addIdentifier('enabled', null, array(
                'label' => 'Activé',
                'datatype' => 'App.Groupeprestataire',
                'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'
            ))
        ;
    }

    // @TODO : NE FONCTIONNE PAS : pour pouvoir classer par nombre de prestataires !
    // voir https://github.com/sonata-project/SonataDoctrineORMAdminBundle/issues/297
    // public function createQuery($context = 'list')
    // {
    //     $query = parent::createQuery($context);
    //     if ('list' === $context) {
    //         $rootAlias = $query->getRootAliases()[0];
    //         $parameters = $this->getFilterParameters();
    //         if ('getPrestatairesCount' === $parameters['_sort_by']) {
    //             $query->select('o', 'DISTINCT o');
    //             $query
    //                 ->leftJoin($rootAlias.'.prestataires', 'gpr')
    //                 // ->leftJoin('groupes_prestataires.prestataires', 'pr')
    //                 ->groupBy($rootAlias.'.id')
    //                 ->orderBy('COUNT(gpr.id)', $parameters['_sort_order'])
    //             ;
    //         }
    //     }
    //     return $query;
    // }
}
