<?php

namespace App\Admin;

use App\Entity\User;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\Translation\TranslatorInterface;

class FluxAdmin extends AbstractAdmin
{
    protected $translator;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setTranslator(TranslatorInterface $translator)
    {
        $this->translator = $translator;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->clearExcept('list');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('type', null, array(
                'label' => 'Type',
                'advanced_filter' => false,
                'show_filter' => true
            ))
            ->add('transfert_or_transaction', 'doctrine_orm_callback', array(
                'label' => "Transfert ou transaction ?",
                'callback' => function ($queryBuilder, $alias, $field, $value) {
                    if (!$value['value']) {
                        return;
                    }
                    $queryBuilder
                        ->where($alias.".parenttype = :type")
                        ->setParameter('type', $value['value']);
                    return true;
                },
                'advanced_filter' => false,
                'show_filter' => true,
                'field_type' => SChoiceType::class,
                'field_options' => array(
                    'choices' => array('Transactions' => 'transaction', 'Transferts' => 'transfert'),
                    'placeholder' => 'Indifférent',
                    'expanded' => true,
                    'multiple' => false
                )
            ))
            ->add('operateur', null, array(
                'label' => 'Operateur',
                'advanced_filter' => false,
                'show_filter' => true
            ))
        ;
    }

    public function getTemplate($name)
    {
        if ($name == 'list') {
            return 'block/base_list_with_total.html.twig';
        }

        return parent::getTemplate($name);
    }

    public function getTotalLabel()
    {
        return $this->translator->trans('Total des transactions :');
    }

    public function getTotal()
    {
        $datagrid = $this->getDatagrid();
        $datagrid->buildPager();
        $query = $datagrid->getQuery();

        $query
            ->select('SUM( ' . $query->getRootAlias() . '.montant) as total')
            ->where($query->getRootAlias().".parenttype = :type")
            ->setParameter('type', 'transaction')
            ->setFirstResult(null)
            ->setMaxResults(null);


        $result = $query->execute(array(), \Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR);

        return $result;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('type', null, array('label' => 'Type'))
            ->addIdentifier('createdAt', null, array('label' => 'Date'))
            ->addIdentifier('operateur', User::class, array('label' => 'Operateur'))
            // ->addIdentifier('expediteur', null, array('label' => 'Expediteur'))
            ->addIdentifier('expediteur', null, array('label' => 'Expediteur'))//, 'template' => 'block/flux_entity.html.twig'))
            ->addIdentifier('destinataire', null, array('label' => 'Destinataire'))
            ->addIdentifier('montant', null, array('label' => 'Montant'))
            ->addIdentifier('reference', null, array('label' => 'Reference'))
        ;
    }
}
