<?php

namespace App\Admin;

use App\Entity\User;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Show\ShowMapper;
use Sonata\MediaBundle\Form\Type\MediaType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;

class FaqAdmin extends AbstractAdmin
{

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $document = $this->getSubject();
        $formMapper
            ->add('user', HiddenType::class, array(
                'data' => $this->getConfigurationPool()->getContainer()->get('security.token_storage')->getToken()->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->getConfigurationPool()->getContainer()->get('doctrine')->getEntityManager()
            ))
            ->add('name', TextType::class, array(
                'label' => 'Titre :'
            ))
            ->add('text', CKEditorType::class, array(
                'label' => 'Texte',
                'required' => false
            ))
            ->add('fichier', MediaType::class, array(
                'provider' => 'sonata.media.provider.file',
                'context' => 'faq',
                'required' => false
            ))
            ->add('image', MediaType::class, array(
                'provider' => 'sonata.media.provider.image',
                'context' => 'faq',
                'required' => false
            ))
            ->add('enabled', CheckboxType::class, array(
                'label' => 'Activé ?',
                'label_attr' => array('class' => 'checkbox-inline'),
                'required' => false
            ))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('name', null, array('label' => 'Titre'))
            ->addIdentifier('text', 'html', array('label' => 'Text'))
            ->addIdentifier('fichier', null, array('label' => 'Fichier'))
            ->addIdentifier('image', null, array('label' => 'Image'))
            ->addIdentifier('user', null, array('label' => 'Utilisateur'))
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.Document', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
        ;
    }
}
