<?php

namespace App\Admin;

use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;

class CotisationPrestataireAdmin extends CotisationAdmin
{
    protected $baseRouteName = 'cotisation_prestataire';
    protected $baseRoutePattern = 'cotisation_prestataire';

    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        // $query->andWhere(
        //     $query->expr()->eq($query->getRootAliases()[0] . '.my_field', ':my_param')
        // );
        // $query->setParameter('my_param', 'my_value');
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
        parent::configureShowFields($showMapper);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        $formMapper
            ->with('Cotisation', ['class' => 'col-md-8'])
                ->add('user', null, array('label' => 'Prestataire'), array('admin_code' => 'admin.prestataire.gerer'))
            ->end()
        ;
        parent::configureFormFields($formMapper);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureRoutes(RouteCollection $collection)
    {
        parent::configureRoutes($collection);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper): void
    {
        parent::configureListFields($listMapper);
    }
}
