<?php

namespace App\Admin;

use App\Enum\MoyenEnum;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;

class CotisationAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'cotisation';
    protected $baseRoutePattern = 'cotisation';

    /**
    * {@inheritdoc}
    */
    protected function configureShowFields(ShowMapper $showMapper)
    {
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {
        $cotisation = $this->getSubject();
        $now = new \DateTime();
        $formMapper
            ->with('Cotisation', ['class' => 'col-md-8'])
                ->add('annee', null, array('label' => 'Année', 'data' => $now->format('Y')))
                ->add('montant', null, array('label' => 'Montant'))
                ->add('moyen', ChoiceType::class, array(
                    'required' => true,
                    'choices' => MoyenEnum::getAvailableTypes(),
                    // 'choices_as_values' => true,
                    'choice_label' => function ($choice) {
                        return MoyenEnum::getTypeName($choice);
                    },
                ))
                ->add('recu', CheckboxType::class, array('label' => 'Reçu'))
            ->end()
            ->with('Date', ['class' => 'col-md-4'])
                ->add('debut', null, array(
                    'label' => 'Date de début',
                    'data' => new \DateTime(),
                    'widget' => 'single_text',
                    'html5' => false,
                    'attr' => ['class' => 'js-datepicker'],
                ))
                ->add('fin', null, array(
                    'label' => 'Date de fin',
                    'data' => new \DateTime('+ 1 year'),
                    'widget' => 'single_text',
                    'html5' => false,
                    'attr' => ['class' => 'js-datepicker'],
                ))
            ->end()
        ;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('edit');
        $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            // ->addIdentifier('user')
            ->addIdentifier('annee')
            ->addIdentifier('debut')
            ->addIdentifier('fin')
            ->addIdentifier('montant')
            ->addIdentifier('moyen')
            ->addIdentifier('createdAt')
        ;
    }
}
