<?php

namespace App\Admin;

use App\Entity\Adherent;
use App\Entity\Geoloc;
use App\Entity\Usergroup;
use Knp\Menu\ItemInterface;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Admin\AdminInterface;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;

class AdherentAdminold extends UserAdmin
{
    protected $baseRouteName = 'adherento';
    protected $baseRoutePattern = 'adherento';

    protected $datagridValues = [
        // reverse order (default = 'ASC')
        '_sort_order' => 'DESC',
        // name of the ordered field (default = the model's id field, if any)
        '_sort_by' => 'ecompte',
        // '_page' => 1,
        // '_per_page' => 32
    ];

    public function configure()
    {
        parent::configure();
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper): void
    {
        parent::configureFormFields($formMapper);
        // Initialize adherent
        $user = $this->getSubject();
        $groupe = $this->getConfigurationPool()->getContainer()->get('doctrine')->getRepository(Usergroup::class)->findOneByName('Adherent');
        $user->setEnabled(true);
        $user->addGroup($groupe);
        $user->addRole('ROLE_ADHERENT');
        $adherent = new Adherent();
        $user->setAdherent($adherent);
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        parent::configureDatagridFilters($datagridMapper);
    }


    protected function configureListFields(ListMapper $listMapper): void
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('username')
            ->addIdentifier('email')
            ->addIdentifier('adherent.ecompte', null, array('label' => 'Ecompte'))
            ->add('groups')
            ->addIdentifier('enabled', null, array('label' => 'Activé', 'datatype' => 'App.User', 'template' => '@SonataAdmin/Boolean/editable_boolean.html.twig'))
            // ->addIdentifier('createdAt')
        ;

        if ($this->isGranted('ROLE_ALLOWED_TO_SWITCH')) {
            $listMapper
                ->addIdentifier('impersonating', 'string', ['template' => '@SonataUser/Admin/Field/impersonating.html.twig'])
            ;
        }
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        // $collection->remove('delete');
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $query = parent::createQuery($context);
        $role = 'ROLE_ADHERENT';
        // $query->andWhere($query->getRootAliases()[0] . '.adherent IS NOT NULL');
        $query->leftJoin($query->getRootAliases()[0] . '.groups', 'g')
                ->where($query->expr()->orX(
                    $query->expr()->like($query->getRootAliases()[0] . '.roles', ':roles'),
                    $query->expr()->like('g.roles', ':roles')
                ))
                ->setParameter('roles', '%"'.$role.'"%');
        return $query;
    }
}
