<?php

namespace App\Security\Voter;

use App\Entity\User;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\AccessDecisionManagerInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

abstract class AbstractVoter extends Voter
{
    const LIST = 'list';        // view the list of objects
    const VIEW = 'view';        // view the detail of one object
    const CREATE = 'create';    // create a new object
    const EDIT = 'edit';        // update an existing object
    const DELETE = 'delete';    // delete an existing object
    const EXPORT = 'export';    // (for the native Sonata export links)
    const ALL = 'all';          // grants LIST, VIEW, CREATE, EDIT, DELETE and EXPORT

    private $decisionManager;

    public function __construct(AccessDecisionManagerInterface $decisionManager)
    {
        $this->decisionManager = $decisionManager;
    }

    protected static function supportsAttribute($attribute)
    {
        // Est-ce que l'action demandée existe
        if (!in_array($attribute, array(self::LIST, self::VIEW, self::CREATE, self::EDIT, self::DELETE, self::EXPORT, self::ALL))) {
            return false;
        }

        return true;
    }

    abstract protected function voteOnAttribute($attribute, $subject, TokenInterface $token);
}
