<?php

namespace App\Repository;

use App\Entity\Adherent;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Symfony\Bridge\Doctrine\RegistryInterface;

/**
 * @method Adherent|null find($id, $lockMode = null, $lockVersion = null)
 * @method Adherent|null findOneBy(array $criteria, array $orderBy = null)
 * @method Adherent[]    findAll()
 * @method Adherent[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class AdherentRepository extends ServiceEntityRepository
{
    public function __construct(RegistryInterface $registry)
    {
        parent::__construct($registry, Adherent::class);
    }

   /**
    * @return Adherent[] Returns an array of Adherent objects
    */
    public function findOrderByName()
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->leftjoin('p.user', 'u')
            ->where('p.enabled = :enabled')
            ->setParameter('enabled', true)
            ->orderBy('u.lastname', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
    * @return Adherent[] Returns an array of Adherent objects
    */
    public function findbyExclude(Adherent $adherent)
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->leftjoin('p.user', 'u')
            ->where('p.id != :presta')
            ->andWhere('p.enabled = :enabled')
            ->setParameter('presta', $adherent->getId())
            ->setParameter('enabled', true)
            ->orderBy('u.lastname', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }
}
