<?php

namespace App\Form\Type;

use App\Entity\Prestataire;
use App\Entity\Siege;
use App\Entity\TransfertPrestataireSiege;
use App\Entity\User;
use App\Enum\MoyenEnum;
use App\Form\Type\TransfertFormType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransfertPrestataireSiegeFormType extends TransfertFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->security->getUser()->getPrestataire()->getId(),
                'data_class' => null,
                'entity_class' => Prestataire::class,
                'em' => $this->em
            ))
            ->add('destinataire', HiddenType::class, array(
                'data' => 1,
                'data_class' => null,
                'entity_class' => Siege::class,
                'em' => $this->em
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransfertPrestataireSiege::class,
        ));
    }

    public function getParent()
    {
        return TransfertFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfertPrestataireSiege';
    }
}
