<?php

namespace App\Form\Type;

use App\Enum\MoyenEnum;
use App\Form\Type\FluxFormType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;

class TransfertFormType extends FluxFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('type', HiddenType::class, array(
                'data' => 'transfert',
                'data_class' => null
            ))
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_TRANSFERT
            ))
        ;
    }

    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransfert';
    }
}
