<?php

namespace App\Form\Type;

use App\Entity\Prestataire;
use App\Entity\TransactionPrestatairePrestataire;
use App\Entity\User;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class TransactionPrestatairePrestataireFormType extends TransactionFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('expediteur', HiddenType::class, array(
                'data' => $this->security->getUser()->getPrestataire()->getId(),
                'data_class' => null,
                'entity_class' => Prestataire::class,
                'em' => $this->em
            ))
            ->add('destinataire', EntityType::class, array(
                'class' => Prestataire::class,
                'choices' =>  $this->em->getRepository(Prestataire::class)->findbyExclude($this->security->getUser()->getPrestataire()),
                'placeholder' => 'Prestataire',
                'required' => true,
                'label' => 'Prestataire :',
            ))
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => TransactionPrestatairePrestataire::class,
        ));
    }

    public function getParent()
    {
        return TransactionFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formTransactionPrestatairePrestataire';
    }
}
