<?php

namespace App\Form\Type;

use App\Entity\Groupeprestataire;
use App\Entity\Prestataire;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CollectionType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;

class GroupePrestataireInscriptionFormType extends AbstractType
{
    protected $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $presta = $options['data'];
        $builder
            ->add('groupeprestataires', CollectionType::class, array(
                'label' => 'AMAP / Marchés',
                'entry_type' => EntityType::class,
                'entry_options' => array(
                    'class' => Groupeprestataire::class,
                    'choices' =>  $this->em->getRepository(Groupeprestataire::class)->findBy(array('enabled' => true), array('name'=> 'ASC')),
                    'choice_label' => 'name',
                    'placeholder' => 'groupe',
                    'required' => false,
                    'label' => false),
                'by_reference' => false,
                'allow_add' => true,
                'allow_delete' => true
            ))
            ->add('save', SubmitType::class, ['label' => "Valider"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Prestataire::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'groupe_presta_inscription';
    }
}
