<?php

namespace App\Traits;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

trait DeleteableEntityTrait
{
    /**
     * @var \DateTime $deletedAt
     *
     * @ORM\Column(name="deletedAt", type="datetime", nullable=true)
     */
    private $deletedAt;

    /**
    * Get deletedAt
    * @return DateTime
    */
    public function getDeletedAt()
    {
        return $this->deletedAt;
    }

    /**
    * Set deletedAt
    * @return $this
    */
    public function setDeletedAt($deletedAt)
    {
        $this->deletedAt = $deletedAt;
        return $this;
    }
}
