<?php

namespace App\Controller\Rest;

use App\Controller\ExceptionFOSRestController;
use App\Entity\User;
use Nelmio\ApiDocBundle\Annotation\ApiDoc;
use Nelmio\ApiDocBundle\Annotation\Model;
use Nelmio\ApiDocBundle\Annotation\Security;
use Swagger\Annotations as SWG;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Routing\Annotation\Route;

class RestController extends ExceptionFOSRestController
{
    /**
     * Renvoi le type d'utilisateur
     *
     * @Route("/api/{user}/type", methods={"GET"})
     * @SWG\Response(
     *     response=200,
     *     description="Returns the type of user",
     *     @SWG\Schema(
     *         type="string"
     *     )
     * )
     * @SWG\Parameter(
     *     name="order",
     *     in="query",
     *     type="string",
     *     description="The field used to order rewards"
     * )
     * @SWG\Tag(name="Utilisateurs")
    */
    public function fetchUserTypeAction(User $user)
    {
        try {
            return new JsonResponse('yes');
            // return 'yes';
        } catch (\Exception $e) {
            $this->throwFosrestSupportedException($exception);
        }
    }
}
