<?php

namespace App\Controller;

use App\Entity\Comptoir;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Routing\Annotation\Route;

class ComptoirController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/comptoirs/liste", name="comptoirs_liste")
     */
    public function listeComptoirAction()
    {
        return $this->render('comptoir/liste.html.twig', array(
            'comptoirs' => $this->em->getRepository(Comptoir::class)->findBy(array('enabled' => true), array('createdAt' => 'DESC'))
        ));
    }

    /**
     * @Route("/comptoirs/carte", name="comptoirs_carte")
     */
    public function carteComptoirAction()
    {
        return $this->render('comptoir/carte.html.twig', array(
            'comptoirs' => $this->em->getRepository(Comptoir::class)->findBy(array('enabled' => true), array('createdAt' => 'DESC'))
        ));
    }

    /**
     * @Route("/comptoir/{slug}", name="show_comptoir")
     */
    public function showGroupeAction(Comptoir $comptoir)
    {
        return $this->render('comptoir/show.html.twig', array(
            'comptoir' => $comptoir
        ));
    }

}
