<?php

namespace App\Admin;

use App\Admin\FluxAdmin;
use App\Entity\User;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * Administration des reconversions (transfert d'un prestataire au siège)
 *
 * LOCO : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class ReconversionAdmin extends FluxAdmin
{
    protected $security;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $user = $this->security->getUser();
        $query = parent::createQuery($context);
        $query->andWhere($query->getRootAliases()[0].".type = :type")
                ->setParameter('type', 'prestataire_siege');
        ;
        return $query;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->addIdentifier('createdAt', null, array('label' => 'Date'))
            ->addIdentifier('type', null, array('label' => 'Type'))
            ->addIdentifier('operateur', User::class, array('label' => 'Operateur'))
            ->addIdentifier('expediteur', null, array('label' => 'Expediteur'))
            ->addIdentifier('destinataire', null, array('label' => 'Destinataire'))
            ->addIdentifier('montant', null, array('label' => 'Montant'))
            ->addIdentifier('reference', null, array('label' => 'Reference'))
            ->addIdentifier('reconverti', null, array('label' => 'Reconverti ?', 'datatype' => 'App.Flux', 'template' => 'block/reconverti_field.html.twig'))
        ;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->remove('transfert_or_transaction')
            ->remove('type')
            ->remove('operateur')
        ;
    }
}
