<?php

namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\Groupe;
use App\Entity\Siege;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransfertGroupeComptoir;
use App\Entity\TransfertGroupeSiege;
use App\Entity\TransfertSiegeGroupe;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\GroupeInfosFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransfertGroupeComptoirFormType;
use App\Form\Type\TransfertGroupeSiegeFormType;
use App\Form\Type\TransfertSiegeGroupeFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserSiegeController extends FluxController
{
    // /**
    //  * @Route("/user/siege/infos", name="groupe_infos")
    //  * @Security("is_granted('ROLE_AMIN_SIEGE') or is_granted('ROLE_SUPER_ADMIN')")
    //  */
    // public function siegeInfosAction(Request $request)
    // {
    //     $form = $this->createForm(SiegeInfosFormType::class, $this->getUser()->getGroupesgere());
    //     $form->handleRequest($request);

    //     if ($form->isSubmitted() && $form->isValid()) {
    //         $data = $form->getData();
    //         $this->em->persist($data);
    //         $this->em->flush();
    //         $this->addFlash(
    //             'success',
    //             'Siege bien modifié !'
    //         );
    //         $referer = $request->headers->get('referer');
    //         if ($referer && !$request->isXmlHttpRequest()) {
    //             return $this->redirect($referer);
    //         } elseif (!$request->isXmlHttpRequest()) {
    //             return new Response('', Response::HTTP_BAD_REQUEST);
    //         }
    //     }

    //     return $this->redirectToRoute('index');
    // }

    /**
     * @Route("/siege/transfert/groupe/", name="transfertSiegeGroupe")
     * @Security("is_granted('ROLE_ADMIN_SIEGE') or is_granted('ROLE_SUPER_ADMIN')")
     */
    public function transfertSiegeGroupeAction(Request $request)
    {
        $entity = new TransfertSiegeGroupe();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertSiegeGroupeFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->em->getRepository(Siege::class)->findOneById(1)->getCompte(),
            $this->translator->trans('Transfert bien effectué !'),
            $this->translator->trans('Transaction à un groupe')
        );
    }

    /**
     * @Route("/groupe/transfert/siege/", name="transfertGroupeSiege")
     * @Security("is_granted('ROLE_ADMIN_SIEGE') or is_granted('ROLE_SUPER_ADMIN')")
     */
    public function transfertGroupeSiegeAction(Request $request)
    {
        $entity = new TransfertGroupeSiege();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertGroupeSiegeFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->em->getRepository(Siege::class)->findOneById(1)->getCompte(),
            $this->translator->trans('Transfert bien effectué !'),
            $this->translator->trans('Transaction du groupe au siège')
        );
    }
}
