<?php

namespace App\Controller;

use App\Entity\News;
use Doctrine\ORM\EntityManagerInterface;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

class NewsController extends AbstractController
{
    private $em;
    private $paginator;

    public function __construct(EntityManagerInterface $em, PaginatorInterface $paginator)
    {
        $this->em = $em;
        $this->paginator = $paginator;
    }

    /**
     * @Route("/news", name="news")
     */
    public function listeNewsAction(Request $request)
    {
        $pagination = $this->paginator->paginate(
            $this->em->getRepository(News::class)->findLatest(),
            $request->query->getInt('page', 1),
            5
        );
        return $this->render('news/liste.html.twig', array(
            'news' => $pagination,
        ));
    }

    /**
     * @Route("/news/{slug}", name="show_news")
     */
    public function showNewsAction(News $news)
    {
        return $this->render('news/show.html.twig', array(
            'news' => $news
        ));
    }
}
