<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Twig;

use Doctrine\ORM\EntityManagerInterface;
use Prodigious\Sonata\MenuBundle\Manager\MenuManager;
use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;
use Twig\TwigFunction;
use Twig\TwigTest;

class MenuExtension extends AbstractExtension
{
    protected $em;
    protected $mm;

    public function __construct(EntityManagerInterface $em, MenuManager $mm)
    {
        $this->em = $em;
        $this->mm = $mm;
    }

    /**
     * {@inheritdoc}
     */
    public function getFunctions()
    {
        return array(
            new \Twig_SimpleFunction('getMenuItemsFromAlias', array($this, 'getMenuItemsFromAlias'))
        );
    }

    public function getMenuItemsFromAlias($alias)
    {
        $menu = $this->mm->loadByAlias($alias);

        if ($menu == null) {
            return null;
        }

        // getMenuItems($menu, $root = MenuManager::ITEM_CHILD, $status = MenuManager::STATUS_ALL)
        $menuItems = $this->mm->getMenuItems($menu, true, true);

        return $menuItems;
    }
}
