<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Security\Handler;

use App\Entity\GlobalParameter;
use Doctrine\ORM\EntityManagerInterface;
use Sonata\AdminBundle\Admin\AdminInterface;
use Sonata\AdminBundle\Security\Handler\RoleSecurityHandler;
use Symfony\Component\Security\Core\Exception\AuthenticationCredentialsNotFoundException;

class VoterSecurityHandler extends RoleSecurityHandler
{
    protected $manager;

    /**
     * {@inheritdoc}
     */
    public function isGranted(AdminInterface $admin, $attributes, $object = null)
    {
        if (!\is_array($attributes)) {
            $attributes = [$attributes];
        }

        foreach ($attributes as $pos => $attribute) {
            $attributes[$pos] = sprintf($this->getBaseRole($admin), $attribute);
        }

        $allRole = sprintf($this->getBaseRole($admin), 'ALL');

        /* Si on utilise le front Wordpress, on ne fait pas apparaitre la gestion du front (faq, page, document, menu, news...) */
        $isWordpress = $this->manager->getRepository(GlobalParameter::class)->val(GlobalParameter::USE_WORDPRESS) != 'false';
        if ($isWordpress) {
            foreach ($attributes as $attribute) {
                if (strpos($attribute, 'ROLE_ADMIN_FAQ') !== false
                    || strpos($attribute, 'ROLE_ADMIN_PAGE') !== false
                    || strpos($attribute, 'ROLE_ADMIN_DOCUMENT') !== false
                    || strpos($attribute, 'ROLE_PRODIGIOUS_SONATA_MENU') !== false
                    || strpos($attribute, 'ROLE_ADMIN_NEWS') !== false) {
                    return false;
                }
            }
        }
        try {
            return $this->isAnyGranted($this->superAdminRoles)
                || $this->isAnyGranted($attributes, $object)
                || $this->isAnyGranted([$allRole], $object);
        } catch (AuthenticationCredentialsNotFoundException $e) {
            return false;
        }
    }

    public function setManager(EntityManagerInterface $manager)
    {
        $this->manager = $manager;
    }

    private function isAnyGranted(array $attributes, $subject = null): bool
    {
        foreach ($attributes as $attribute) {
            if ($this->authorizationChecker->isGranted($attribute, $subject)) {
                return true;
            }
        }

        return false;
    }
}
