<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Repository;

use App\Entity\Groupe;
use App\Entity\Groupeprestataire;
use App\Entity\Prestataire;
use App\Entity\Rubrique;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Common\Persistence\ManagerRegistry;

/**
 * @method Prestataire|null find($id, $lockMode = null, $lockVersion = null)
 * @method Prestataire|null findOneBy(array $criteria, array $orderBy = null)
 * @method Prestataire[]    findAll()
 * @method Prestataire[]    findBy(array $criteria, array $orderBy = null, $limit = null, $offset = null)
 */
class PrestataireRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Prestataire::class);
    }

    /**
     * Find prestataire from geoloc lat/lon and distance in meters
    * @return Prestataire[] Returns an array of Prestataire objects
    */
    public function findByGeoloc($lat, $lon, $distance)
    {
        // @TODO : optimize geoloc (better SQL search, bundles ???)
        // https://numa-bord.com/miniblog/doctrine-recherche-table-contenant-latitudes-longitudes-celle-situes-a-de-xx-km/
        // https://stackoverflow.com/questions/24370975/find-distance-between-two-points-using-latitude-and-longitude-in-mysql
        $sqlDistance = '(6373000 * acos(cos(radians(' . $lat . ')) * cos(radians(g.lat)) * cos(radians(g.lon) - radians(' . $lon . ')) + sin(radians(' . $lat . ')) * sin(radians(g.lat))))';
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->leftJoin('p.geolocs', 'gs')
            ->leftJoin('gs.geoloc', 'g')
            ->andWhere('p.enabled = :enabled')
            ->setParameter('enabled', true)
            ->andWhere('p.mlc = :mlc')
            ->setParameter('mlc', false)
            ->andWhere("" . $sqlDistance . " < :distance")
            ->setParameter('distance', $distance)
            ->orderBy('p.raison', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
    * @return Prestataire[] Returns an array of Prestataire objects
    */
    public function findByRubrique(Rubrique $rubrique)
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->where($qb->expr()->isMemberOf(':rubrique', 'p.rubriques'))
            ->andWhere('p.enabled = :enabled')
            ->setParameter('rubrique', $rubrique)
            ->setParameter('enabled', true)
            ->orderBy('p.raison', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
    * @return Prestataire[] Returns an array of Prestataire objects
    */
    public function findByGroupeLocal(Groupe $groupe)
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->where('p.groupe = :groupe')
            ->andWhere('p.enabled = :enabled')
            ->setParameter('groupe', $groupe)
            ->setParameter('enabled', true)
            ->orderBy('p.raison', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
    * @return Prestataire[] Returns an array of Prestataire objects
    */
    public function findByGroupeprestataire(Groupeprestataire $groupe)
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->where($qb->expr()->isMemberOf(':groupe', 'p.groupeprestataires'))
            ->andWhere('p.enabled = :enabled')
            ->setParameter('groupe', $groupe)
            ->setParameter('enabled', true)
            ->orderBy('p.raison', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }

    /**
    * @return Prestataire[] Returns an array of Prestataire objects
    */
    public function findbyExclude(Prestataire $presta)
    {
        $qb = $this->createQueryBuilder('p');
        return $qb
            ->where('p.id != :presta')
            ->andWhere('p.enabled = :enabled')
            ->setParameter('presta', $presta->getId())
            ->setParameter('enabled', true)
            ->orderBy('p.raison', 'ASC')
            ->getQuery()
            ->getResult()
        ;
    }
}
