<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Flux;
use App\Entity\User;
use App\Enum\MoyenEnum;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\MoneyType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormError;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Validator\Constraints\LessThanOrEqual;

class FluxFormType extends AbstractType
{
    protected $em;
    protected $security;
    protected $container;
    protected $session;

    public function __construct(EntityManagerInterface $em,
                                Security $security,
                                ContainerInterface $container,
                                SessionInterface $session)
    {
        $this->em = $em;
        $this->security = $security;
        $this->container = $container;
        $this->session = $session;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $flux = $options['data'];
        if (empty($this->security->getUser()) || empty($this->security->getUser()->getId())) {
            throw new \Exception("[FLUX] Opération impossible ! Pas d'utilisateur connecté !");
        }
        if (empty($flux)) {
            throw new \Exception("[FLUX] Opération impossible ! Pas de flux paramétré !");
        }
        // if (empty($flux) || empty($flux->getExpediteur())) {
        //     throw new \Exception("[FLUX] Opération impossible ! Pas d'expediteur paramétré !");
        // }
        $builder
            ->add('operateur', HiddenType::class, array(
                'data' => $this->security->getUser()->getId(),
                'data_class' => null,
                'entity_class' => User::class,
                'em' => $this->em
            ))
            ->add('role', HiddenType::class, array(
                'data' => $this->security->getUser()->getGroups()[0]->__toString()
            ))
        ;
        if (empty($flux->getExpediteur())) {
            $builder
                ->add('montant', MoneyType::class, array(
                    'label' => 'Montant :',
                    'required' => true
                ))
            ;
        } else {
            $constraintsMontant = [];
            if ($flux->getParenttype() == Flux::TYPE_TRANSACTION || $flux->getType() == 'reconversion') {
                $constraintsMontant = [
                    new LessThanOrEqual([
                        'message' => 'Montant supérieur à votre solde.',
                        'value' => $flux->getExpediteur()->getEcompte(),
                    ]),
                ];
            } elseif ($flux->getParenttype() != Flux::TYPE_COTISATION) {
                $constraintsMontant = [
                    new LessThanOrEqual([
                        'message' => 'Montant supérieur à votre solde.',
                        'value' => $flux->getExpediteur()->getCompte(),
                    ]),
                ];
            }
            $builder
                ->add('montant', MoneyType::class, array(
                    'label' => 'Montant :',
                    'required' => true,
                    'constraints' => $constraintsMontant,
                ))
            ;
        }
        $builder
            ->add('reference', TextType::class, array(
                'label' => 'Reference :',
                'required' => true
            ))
            ->add('save', SubmitType::class, array(
                'label' => "Valider"
            ))
            ->addEventListener(FormEvents::POST_SUBMIT, function (FormEvent $event) use ($builder) {
                $flux = $event->getData();
                if ($event->getForm()->isValid() && (!$flux || null === $flux->getId()) && $flux->getParenttype() == Flux::TYPE_COTISATION && $flux->getMoyen() == MoyenEnum::MOYEN_MLC) {
                    if ($flux->getExpediteur()->getEcompte() < $flux->getMontant()) {
                        $event->getForm()->get('montant')->addError(new FormError("Montant supérieur à votre solde !"));
                    }
                }
            })
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
        'data_class' => Flux::class,
        'cascade_validation' => true
        ));
    }

    public function getBlockPrefix()
    {
        return 'formFlux';
    }
}
