<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Adherent;
use App\Entity\Groupe;
use App\Entity\Prestataire;
use App\Entity\User;
use App\Form\Type\GeolocFormType;
use App\Form\Type\UserInfosFormType;
use Doctrine\DBAL\Types\FloatType;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\EntityManagerInterface;
use Doctrine\ORM\EntityRepository;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\CheckboxType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Security\Core\Security;

class AdherentInfosFormType extends AbstractType
{
    protected $container;
    protected $em;
    protected $security;

    public function __construct(ContainerInterface $container, EntityManagerInterface $em, Security $security)
    {
        $this->container = $container;
        $this->em = $em;
        $this->security = $security;
    }

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('user', UserInfosFormType::class, array(
                'label' => false
            ))
            ->add('geoloc', GeolocFormType::class, array(
                'label' => false,
                'required' => true,
                'with_geoloc' => false,
                'with_latlon' => false
            ))
            // ->add('groupe', ChoiceType::class, array(
            //     'required' => true,
            //     'disabled' => true,
            //     'label' => 'GROUPE LOCAL',
            //     'choices' => $this->container->get('doctrine')->getRepository(Groupe::class)->findAll(),
            //     'choice_label' => 'name',
            //     'placeholder' => 'Choisir un groupe',
            // ))
            ->add('save', SubmitType::class, ['label' => "Modifier"])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => Adherent::class,
            'cascade_validation' => true
        ]);
    }

    public function getBlockPrefix()
    {
        return 'formAdherentInfos';
    }
}
