<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Prestataire;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;

class AchatMonnaiePrestataireFormType extends AchatMonnaieFormType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if (empty($this->security) || empty($this->security->getUser())) {
            throw new \Exception("[FORM ACHAT MONNAIE PRESTATAIRE] Opération impossible !");
        }
        $builder
            -> add('destinataire', HiddenType::class, array(
              'data' => $this->session->get('_prestagere')->getId(),
              'data_class' => null,
              'entity_class' => Prestataire::class,
              'em' => $this->em
            ))
            ->add('reference', HiddenType::class, array(
                'data' => 'Achat monnaie en CB Prestataire'
            ))
            ->add('save', SubmitType::class, ['label' => "Payer en CB"])
        ;
    }

    /**
     * {@inheritdoc}
     */
    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'class' => AchatMonnaiePrestataire::class,
        ));
    }

    public function getParent()
    {
        return AchatMonnaieFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formAchatMonnaiePrestataire';
    }
}
