<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Form\Type;

use App\Entity\Siege;
use App\Enum\MoyenEnum;
use App\Form\Type\FluxFormType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\RangeType;

class AchatMonnaieFormType extends FluxFormType
{

    private $defaultMontantSlider = 30;
    private $maxMontantSlider = 250;

    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('moyen', HiddenType::class, array(
                'data' => MoyenEnum::MOYEN_CB
            ))
            ->add('expediteur', HiddenType::class, array(
                'data' => 1,
                'data_class' => null,
                'entity_class' => Siege::class,
                'em' => $this->em
            ))
            ->add('montantradio', ChoiceType::class, array(
                'choices'  => [
                    '30 €' => 30,
                    '50 €' => 50,
                    '100 €' => 100,
                ],
                'required' => false,
                'placeholder' => false,
                'data' => $this->defaultMontantSlider,
                'expanded' => true,
                'multiple' => false,
                'label' => 'Sélectionnez un montant :',
                'mapped' => false
            ))
            ->add('montant', RangeType::class, [
                 'attr' => [
                    "min" => 0,
                    "max" => $this->maxMontantSlider,
                    "data-provide" => "slider",
                    "data-slider-ticks" => "[0, 50, 100, 150, 200, 250]",
                    "data-slider-ticks-labels" => '[0, 50, 100, 150, 200, 250]',
                    "data-slider-ticks-positions" => '[0, 20, 40, 60, 80, 100]',
                    "data-slider-min" => "0",
                    "data-slider-max" => $this->maxMontantSlider,
                    "data-slider-step" => "5",
                    "data-slider-value" => $this->defaultMontantSlider,
                    "style" => "width:100%;",
                    "class" => "achatmonnaie-montant-slider"
                 ],
                 'label' => 'Ou choisissez librement le montant : ',
                 'required' => false
             ])
        ;
    }

    public function getParent()
    {
        return FluxFormType::class;
    }

    public function getBlockPrefix()
    {
        return 'formAchatMonnaie';
    }
}
