<?php
namespace App\EventListener;
/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 

use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Event\FormEvent;
use FOS\UserBundle\Event\UserEvent;
use FOS\UserBundle\FOSUserEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Routing\RouterInterface;
use Symfony\Component\Security\Csrf\TokenGenerator\TokenGeneratorInterface;

/**
 * Listener responsible to change the redirection at the end of the password resetting
 */
class UserListener implements EventSubscriberInterface
{
    protected $em;
    protected $router;
    protected $session;
    protected $tokenGenerator;

    public function __construct(EntityManagerInterface $em, RouterInterface $router, SessionInterface $session, TokenGeneratorInterface $tokenGenerator)
    {
        $this->em = $em;
        $this->router = $router;
        $this->session = $session;
        $this->tokenGenerator = $tokenGenerator;
    }

    public static function getSubscribedEvents()
    {
        return array(
            FOSUserEvents::CHANGE_PASSWORD_SUCCESS => 'onChangePasswordSuccess',
            FOSUserEvents::REGISTRATION_SUCCESS => 'onRegistrationSuccess',
            FOSUserEvents::REGISTRATION_FAILURE => 'onRegistrationFailure',
            FOSUserEvents::RESETTING_RESET_SUCCESS => 'onResetSuccess',
            FOSUserEvents::USER_CREATED => 'onUserCreated',
        );
    }

    public function onChangePasswordSuccess(FormEvent $event)
    {
        $url = $this->router->generate('index');
        $event->setResponse(new RedirectResponse($url));
    }

    public function onRegistrationSuccess(FormEvent $event)
    {
        $url = $this->router->generate('index');
        $event->setResponse(new RedirectResponse($url));
    }

    public function onRegistrationFailure(FormEvent $event)
    {
        $url = $this->router->generate('index');
        $event->setResponse(new RedirectResponse($url));
    }

    public function onResetSuccess(FormEvent $event)
    {
        $url = $this->router->generate('index');
        $event->setResponse(new RedirectResponse($url));
    }

    public function onUserCreated(UserEvent $event)
    {
        // @TODO : notification ?
    }
}
