<?php
namespace App\EventListener;
/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 

use App\Entity\Geoloc;
use Doctrine\Common\Persistence\Event\LifecycleEventArgs;
use Doctrine\ORM\Event\PreUpdateEventArgs;
use Geocoder\Provider\Nominatim\Nominatim;
use Geocoder\Query\GeocodeQuery;

class GeolocListener
{
    public function postPersist(LifecycleEventArgs $eventArgs)
    {
        $entity = $eventArgs->getObject();
        $this->updateGeoLoc($entity);
    }

    public function preUpdate(PreUpdateEventArgs $eventArgs)
    {
        $entity = $eventArgs->getEntity();
        if (!($entity instanceof Geoloc) || ($entity instanceof Geoloc) && !($eventArgs->hasChangedField('adresse') || $eventArgs->hasChangedField('cpostal') || $eventArgs->hasChangedField('ville') || $eventArgs->hasChangedField('lat') || $eventArgs->hasChangedField('lon'))) {
            return;
        }
        $this->updateGeoLoc($entity);
    }

    private function updateGeoLoc($entity)
    {
        if (!$entity instanceof Geoloc) {
            return;
        }
        if (empty($entity->getLat()) && empty($entity->getLon())) {
            // GEOCODING ADDRESS :
            $httpClient = new \Http\Adapter\Guzzle6\Client();
            $provider = Nominatim::withOpenStreetMapServer($httpClient, 'Mozilla/5.0');
            $geocoder = new \Geocoder\StatefulGeocoder($provider, 'fr');
            $fullAddress = $entity->getAdresse().' '.$entity->getCpostal().' '.$entity->getVille();
            // Query geocoding from complete address
            $result = $geocoder->geocodeQuery(GeocodeQuery::create($fullAddress));
            if (count($result) > 0) {
                $coords = $result->first()->getCoordinates();
                $entity->setLat($coords->getLatitude());
                $entity->setLon($coords->getLongitude());
            }
        }
    }
}
