<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TRANSFERT
 *  - PRESTATAIRES      =>     COMPTOIRS       (dépôt de billet et chargement du compte numérique)
 *
 * @ORM\Entity()
 */
class TransfertPrestataireComptoir extends Transfert
{
    /**
     * @ORM\OneToOne(targetEntity="Prestataire")
     * @ORM\JoinColumn(name="prestataire_id", referencedColumnName="id")
     */
    protected $expediteur;

    /**
     * @ORM\OneToOne(targetEntity="Comptoir")
     * @ORM\JoinColumn(name="comptoir_id", referencedColumnName="id")
     */
    protected $destinataire;

    /**
     * @return string
     */
    public function getType(): string
    {
        return 'prestataire_comptoir';
    }

    public function operate($em)
    {
        // On augmente le compte de e-mmonaie du presta
        $this->getExpediteur()->addEcompte($this->getMontant());

        // On augmente le solde billets du comptoir
        $this->getDestinataire()->addCompte($this->getMontant());

        // On baisse le solde de billets nanties au siège
        $this->getDestinataire()->getGroupe()->getSiege()->removeCompteNantie($this->getMontant());

        // On augmente le solde de e-monnaie nantie du siège
        $this->getDestinataire()->getGroupe()->getSiege()->addEcompte($this->getMontant());

        return [
            $this->getExpediteur(),
            $this->getDestinataire(),
            $this->getDestinataire()->getGroupe()->getSiege(), // fix #469: do not forget to persist the 'Siege' entity
        ];
    }

    public function getUsersToNotify()
    {
        return array_merge(
            $this->getDestinataire()->getGestionnaires()->toArray(),
            $this->getExpediteur()->getUsers()->toArray()
        );
    }
}
