<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\DataFixtures;

use Doctrine\Bundle\FixturesBundle\Fixture;
use Doctrine\Common\Persistence\ObjectManager;

use App\Entity\Usergroup;

class AppFixturesPatches extends Fixture
{
    public function load(ObjectManager $manager)
    {
        self::updateTresorierRole($manager);
        self::addCaissiersRoles($manager);
    }

    /**
     * Add to Tresorier role the permission to view all flux in admin
     */
    public function updateTresorierRole(ObjectManager $manager)
    {
        $usergroup = $manager->getRepository(UserGroup::class)->findOneBy([
            'name' => 'Tresorier',
        ]);

        $roles = $usergroup->getRoles();

        $found = false;
        foreach ($roles as $key => $role) {
            if ($role == 'ROLE_ADMIN_FLUX_GERER_ALL') {
                $found = true;
            }
        }

        if (!$found) {
            $roles[] = 'ROLE_ADMIN_FLUX_GERER_ALL';
            $usergroup->setRoles($roles);
            $manager->flush();
        }
    }

    /**
     * Add to Tresorier role the permission to view all flux in admin
     */
    public function addCaissiersRoles(ObjectManager $manager)
    {
        $usergroup = $manager->getRepository(Usergroup::class)->findOneBy([
            'name' => 'Caissier de Prestataire',
        ]);

        if (!$usergroup) {
            $usergroup = new Usergroup('Caissier de Prestataire');
            $usergroup->setRoles(['ROLE_CAISSIER_PRESTATAIRE']);

            $manager->persist($usergroup);
        }

        $usergroup = $manager->getRepository(Usergroup::class)->findOneBy([
            'name' => 'Caissier de Comptoir',
        ]);

        if (!$usergroup) {
            $usergroup = new Usergroup('Caissier de Comptoir');
            $usergroup->setRoles(['ROLE_CAISSIER_COMPTOIR']);

            $manager->persist($usergroup);
        }

        $manager->flush();
    }
}
