<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\Adherent;
use App\Entity\Cotisation;
use App\Entity\Geoloc;
use App\Entity\Groupe;
use App\Entity\TransactionAdherentPrestataire;
use App\Entity\TransfertComptoirGroupe;
use App\Entity\TransfertGroupeComptoir;
use App\Entity\Usergroup;
use App\Form\Type\AdherentInfosFormType;
use App\Form\Type\AdhererFormType;
use App\Form\Type\GroupeInfosFormType;
use App\Form\Type\TransactionAdherentPrestataireFormType;
use App\Form\Type\TransfertComptoirGroupeFormType;
use App\Form\Type\TransfertGroupeComptoirFormType;
use Doctrine\ORM\EntityManagerInterface;
use FOS\UserBundle\Model\UserManagerInterface;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\IsGranted;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Security;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Translation\TranslatorInterface;

class UserGestionnaireGroupeController extends FluxController
{
    /**
     * @Route("/user/groupe/infos", name="groupe_infos")
     * @IsGranted({"ROLE_GESTION_GROUPE", "ROLE_CONTACT", "ROLE_TRESORIER"})
     */
    public function groupeInfosAction(Request $request)
    {
        // @TODO : récupérer groupe gere en session
        $form = $this->createForm(GroupeInfosFormType::class, $this->session->get('_groupegere'));
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $data = $form->getData();
            $this->em->persist($data);
            $this->em->flush();
            $this->addFlash(
                'success',
                $this->translator->trans('Groupe local bien modifié !')
            );
            $referer = $request->headers->get('referer');
            if ($referer && !$request->isXmlHttpRequest()) {
                return $this->redirect($referer);
            } elseif (!$request->isXmlHttpRequest()) {
                return new Response('', Response::HTTP_BAD_REQUEST);
            }
        }

        return $this->redirectToRoute('index');
    }

    /**
     * @Route("/user/groupe/transfert/comptoir/", name="transfertGroupeComptoir")
     * @IsGranted("ROLE_GESTION_GROUPE")
     */
    public function transfertGroupeComptoirAction(Request $request)
    {
        $entity = new TransfertGroupeComptoir();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertGroupeComptoirFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_groupegere')->getCompte(),
            $this->translator->trans('Transfert bien effectué !'),
            $this->translator->trans('Transfert à un comptoir')
        );
    }

    /**
     * @Route("/user/groupe/retour/comptoir/", name="transfertComptoirGroupe")
     * @IsGranted("ROLE_GESTION_GROUPE")
     */
    public function transfertComptoirGroupeAction(Request $request)
    {
        $entity = new TransfertComptoirGroupe();
        $entity->setOperateur($this->getUser());
        $form = $this->createForm(TransfertComptoirGroupeFormType::class, $entity);
        return $this->manageFluxForm(
            $request,
            $form,
            $this->session->get('_groupegere')->getCompte(),
            $this->translator->trans('Retour bien effectuée !'),
            $this->translator->trans('Retour au groupe')
        );
    }
}
