<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Controller;

use App\Entity\Groupeprestataire;
use App\Entity\Prestataire;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 *
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class GroupePrestaController extends AbstractController
{
    private $em;

    public function __construct(EntityManagerInterface $em)
    {
        $this->em = $em;
    }

    /**
     * @Route("/prestataires/groupe/{slug}", name="show_groupeprestataire")
     */
    public function showGroupeAction(Groupeprestataire $groupe)
    {
        return $this->render('groupepresta/show.html.twig', array(
            'groupe' => $groupe
        ));
    }

    /**
     * @Route("/groupe/prestataires/{type}/liste", name="groupepresta_liste")
     */
    public function listeGroupePrestaAction($type, Request $request)
    {
        $groupe = $this->em->getRepository(Groupeprestataire::class)->findBy(array('type' => $type, 'enabled' => true), array('name'=> 'ASC'));

        return $this->render('groupepresta/liste.html.twig', array(
            'groupes' => $groupes,
            'groupetype' => $type
        ));
    }

    /**
     * @Route("/groupe/prestataires/{type}/carte", name="groupepresta_carte")
     */
    public function carteGroupePrestaAction($type, Request $request)
    {
        $groupes = $this->em->getRepository(Groupeprestataire::class)->findBy(array('type' => $type, 'enabled' => true));

        return $this->render('groupepresta/carte.html.twig', array(
            'groupes' => $groupes,
            'groupetype' => $type
        ));
    }
}
