<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use App\Admin\FluxAdmin;
use App\Entity\User;
use App\Entity\Flux;
use App\Entity\Prestataire;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Form\Type\Filter\ChoiceType;
use Sonata\AdminBundle\Route\RouteCollection;
use Sonata\AdminBundle\Show\ShowMapper;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType as SChoiceType;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Symfony\Component\Security\Core\Security;
use Symfony\Component\Translation\TranslatorInterface;

/**
 * Administration des transferts
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Julien Jorry <julien.jorry@gmail.com>
 */
class TransfertAdmin extends FluxAdmin
{
    protected $security;
    protected $session;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    public function setSession(SessionInterface $session)
    {
        $this->session = $session;
    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->clearExcept(array('list', 'export'));
    }

    /**
    * {@inheritdoc}
    */
    public function createQuery($context = 'list')
    {
        $user = $this->security->getUser();
        $query = parent::createQuery($context);
        // $query->andWhere($query->getRootAliases()[0].".parenttype = :type")
        // ->setParameter('type', 'transfert');

        $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();
        $fluxtable =  $em->getMetadataFactory()->getMetadataFor(Flux::class)->getTableName();
        if ($this->security->getUser()->isGranted('ROLE_GESTION_GROUPE') || $this->security->getUser()->isGranted('ROLE_CONTACT') || $this->security->getUser()->isGranted('ROLE_TRESORIER')) {
            if (empty($this->getRequest()->getSession()->get('_groupegere'))) {
                $query->andWhere('false = true');
            } else {
                $groupe = $this->getRequest()->getSession()->get('_groupegere');
                $connection = $em->getConnection();
                $prestatable =  $em->getMetadataFactory()->getMetadataFor(Prestataire::class)->getTableName();
                $statement = $connection->prepare('SELECT f.id FROM '.$fluxtable.' f WHERE f.groupe_id = '.$groupe->getId().' OR (f.type = \'reconversion\' AND f.prestataire_id IN (SELECT p.id FROM '.$fluxtable.' p WHERE p.groupe_id = '.$groupe->getId().'))');
                $statement->execute();
                $ids = $statement->fetchAll();
                $query
                    ->andWhere($query->expr()->in($query->getRootAliases()[0].'.id', ':ids'))
                    ->setParameter('ids', $ids)
                ;
            }
        } elseif ($this->security->getUser()->isGranted('ROLE_COMPTOIR')) {
            if (empty($this->getRequest()->getSession()->get('_comptoirgere'))) {
                $query->andWhere('false = true');
            } else {
                $comptoir = $this->getRequest()->getSession()->get('_comptoirgere');
                $em = $this->getConfigurationPool()->getContainer()->get('doctrine')->getManager();
                $connection = $em->getConnection();
                $statement = $connection->prepare('SELECT f.id FROM '.$fluxtable.' f WHERE f.comptoir_id = '.$comptoir->getId().' OR f.user_id = '.$user->getId());
                $statement->execute();
                $ids = $statement->fetchAll();
                $query
                    ->andWhere($query->expr()->in($query->getRootAliases()[0].'.id', ':ids'))
                    ->setParameter('ids', $ids)
                ;
            }
        }
        return $query;
    }

    public function getTotalLabel()
    {
        return $this->translator->trans('Total des transferts :');
    }

    public function getTotal()
    {
        $datagrid = $this->getDatagrid();
        $datagrid->buildPager();

        $query = clone $datagrid->getQuery();
        $query
            ->select('SUM( ' . $query->getRootAlias() . '.montant) as total')
            ->andWhere($query->getRootAlias().".parenttype = :type")
            ->setParameter('type', 'transfert')
            ->setFirstResult(null)
            ->setMaxResults(null);

        $result = $query->execute(array(), \Doctrine\ORM\Query::HYDRATE_SINGLE_SCALAR);

        return $result;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper
            ->add('type', null, array(
                'label' => 'Type de transfert',
                'advanced_filter' => false,
                'show_filter' => true
            ))
            ->add('operateur', null, array(
                'label' => 'Operateur',
                'advanced_filter' => false,
                'show_filter' => true
            ))
        ;
    }
  //Surcharge pour que tous les champs visibles à l'écran soient présent dans l'export
  public function getExportFields()
  {
      return [
          'Date'                => 'createdAt',
          'Type de transfert'   => "type",
          'Montant'             => 'montant',
          'Expediteur'          => 'expediteur',
          'Destinataire'        => 'destinataire',
          'Opérateur'           => 'operateur',
          'Référence'           => 'reference'
      ];
  }

}
