<?php

/*
 * kohinos_cooperatic
 * Copyright (C) 2019-2020  ADML63
 * Copyright (C) 2020- Cooperatic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
namespace App\Admin;

use App\Entity\User;
use Sonata\AdminBundle\Admin\AbstractAdmin;
use Sonata\AdminBundle\Datagrid\DatagridMapper;
use Sonata\AdminBundle\Datagrid\ListMapper;
use Sonata\AdminBundle\Form\FormMapper;
use Sonata\AdminBundle\Route\RouteCollection;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Security\Core\Security;


/**
 * Administration des flux 'Achat de monnaie'
 *
 * KOHINOS : Outil de gestion de Monnaie Locale Complémentaire
 * @author Damien Moulard <dam.moulard@gmail.com>
 */
class AchatMonnaieAdmin extends AbstractAdmin
{
    protected $baseRouteName = 'achat_monnaie';
    protected $baseRoutePattern = 'achat_monnaie';
    protected $security;

    protected $translator;
    protected $datagridValues = [
        '_sort_order' => 'DESC',
        '_sort_by' => 'createdAt',
    ];

    public function setSecurity(Security $security)
    {
        $this->security = $security;
    }

    /**
    * {@inheritdoc}
    */
    protected function configureDatagridFilters(DatagridMapper $datagridMapper): void
    {
        $datagridMapper->add('type', null, array(
            'advanced_filter' => false,
            'show_filter' => true,
            'field_type' => ChoiceType::class,
            'field_options' => array(
                'choices' => array('Adhérent' => 'achat_monnaie_adherent', 'Prestataire' => 'achat_monnaie_prestataire'),
                'placeholder' => 'Indifférent',
                'expanded' => true,
                'multiple' => false
            )
        ));
    }

    /**
    * {@inheritdoc}
    */
    protected function configureFormFields(FormMapper $formMapper)
    {

    }

    protected function configureRoutes(RouteCollection $collection)
    {
        $collection->remove('delete');
        if ($this->security->getUser() != null && !($this->security->getUser()->isGranted('ROLE_TRESORIER') || $this->security->getUser()->isGranted('ROLE_SUPER_ADMIN') || $this->security->getUser()->isGranted('ROLE_COMPTOIR'))) {
            $collection->clearExcept(array('list', 'export'));
        }
    }

    /**
    * {@inheritdoc}
    */
    protected function configureListFields(ListMapper $listMapper)
    {
        unset($this->listModes['mosaic']);
        $listMapper
            ->add('createdAt', 'datetime', array('label' => 'Date'))
            ->add('montant', null, array('label' => 'Montant'))
            ->add('destinataire', null, array('label' => 'Destinataire'))
            ->add('operateur', null, array('label' => 'Operateur'))
            ->add('reference', null, array('label' => 'Reference'))
        ;
    }

    //Surcharge pour que tous les champs visibles à l'écran soient présent dans l'export
    public function getExportFields()
    {
        return [
            'Date'           => 'createdAt',
            'Montant'        => 'montant',
            'Destinataire'   => 'destinataire',
            'Opérateur'      => 'operateur',
            'Référence'      => 'reference'
        ];
    }
}
