import sys
from ci_secrets import coops_mails

def is_coop_supported(coop):
    return coop in coops_mails and coops_mails[coop]


def is_instance_supported(instance):
    return instance == "preprod" or instance == "test" or instance == "dev" or instance == "prod"


def get_mail(coop):
    return coops_mails[coop]


if __name__ == '__main__':
    coop = ""
    instance = ""
    if len(sys.argv) == 3:
        coop = sys.argv[1]
        instance = sys.argv[2]
    if is_coop_supported(coop) and is_instance_supported(instance):
        sys.exit(0)
    else:
        sys.exit(1)
