prepare_mail() {
  #Read arguments and set variables
  coop=$1
  instance=$2
  repo=$3
  now=$4
  send_mails=$5
  ci_dir=$6
  ci_data_dir=$7
  if [[ ${repo} == "third-party" ]]; then
    user="django"
  elif [[ ${repo} == "Odoo" ]]; then
    user="odoo"
  else
    echo "Incorrect repo name : ${repo}"
    if ${send_mails}; then
      python3 "${ci_dir}/send_error_mail.py" "${coop} ${instance} ${repo} : incorrect repo name"
    fi
    exit 1
  fi

  cd /home/${user}/${repo}
  su ${user} -c "git fetch --all"

  #Check branch
  branch_found_str=$( su ${user} -c "git ls-remote origin ${coop}_prod" ) #seems that git ls-remote is not "failing" so we need to check output
  if [ -z "${branch_found_str}" ]; then
    #branch prod does not exist, cannot go on
    echo "${coop} ${instance} ${repo}: branch ${coop}_prod does not exist"
    if ${send_mails}; then
      python3 "${ci_dir}/send_error_mail.py" "${coop} ${instance} ${repo} : branch ${coop}_prod does not exist"
    fi
    exit 1
  fi


  ###COMPARE BRANCHES AND DECIDE IF WE NEED TO CREATE A FILE CONTAINING NEW COMMITS###

  #initialize file
  if ! test -f "${ci_data_dir}/ci_diff_${repo}_last.txt"; then
    touch "${ci_data_dir}/ci_diff_${repo}_last.txt"
  fi

  #new_commits="$( git log origin/${coop}_prod...origin/dev_cooperatic --no-merges --oneline )" (old version)

  #Let's break down the new big line below :
  #origin/${coop}_prod...origin/dev_cooperatic : we look for difference between develop branch and prod branch
  #--pretty=format:'%s' : get rid of commit id
  #the big grep+sed group : discard lines not maching pattern "merge [0-9]\+-... into dev_cooperatic" and only keep the [0-9]\+-.... part with a link to redmine
  new_commits="$( git log origin/${coop}_prod...origin/dev_cooperatic --merges --oneline --pretty=format:'%s' | grep "into 'dev_cooperatic'" | sed "s/Merge branch '//g" | sed "s/' into 'dev_cooperatic'//g" | grep "^[0-9]\+" | sed -E 's/(^[0-9]+)/\<a href=\"https\:\/\/redmine.coopdev.fr\/issues\/\1\"\>\1\<\/a\>/g' )"
  if [ -z "${new_commits}" ]; then
    echo "${coop} ${instance} ${repo} : no difference between prod and dev_cooperatic"
    #There are no difference between prod and dev_cooperatic therefore we don't want to send email for this repo.
    #To inform the mailer that there is nothing new, we do not create ci_diff file at current time.
    #The mailer will therefore use ci_diff_last to get the list of commits for the client.
    #Not only there is nothing new, but also there is just no difference,
    #therefore we need to erase the content the ci_diff_last file if not already empty (save time of first time it was erased)
    if [[ -s "${ci_data_dir}/ci_diff_${repo}_last.txt" ]]; then
      > "${ci_data_dir}/ci_diff_${repo}_last.txt"
    fi
  else
    echo "${new_commits}" > "${ci_data_dir}/ci_diff_${repo}_${now}.txt"

    #See if commit difference is the same than last time
    if cmp "${ci_data_dir}/ci_diff_${repo}_last.txt" "${ci_data_dir}/ci_diff_${repo}_${now}.txt"; then
      #As there are no new commits in prod, we don't want to send email for this repo.
      #To indicate that, we delete just created ci_diff file at current time.
      rm "${ci_data_dir}/ci_diff_${repo}_${now}.txt"
      echo "${coop} ${instance} ${repo} : ci_diff_${repo} files are identical"
    else
      #We have created new ci_diff.
      #Replace old ci_diff_last by new one
      rm "${ci_data_dir}/ci_diff_${repo}_last.txt"
      cp "${ci_data_dir}/ci_diff_${repo}_${now}.txt" "${ci_data_dir}/ci_diff_${repo}_last.txt"
    fi
  fi

}