var makeups_members_table = null,
    makeups_members = null,
    members_search_results = [],
    selected_rows = []; // Contain members id


/**
 * Load partners who have makeups to do
 */
function load_makeups_members() {
    $.ajax({
        type: 'GET',
        url: "/members/get_makeups_members",
        dataType:"json",
        traditional: true,
        contentType: "application/json; charset=utf-8",
        success: function(data) {
            makeups_members = data.res;
            display_makeups_members();
        },
        error: function(data) {
            err = {msg: "erreur serveur lors de la récupération des membres avec rattrapage", ctx: 'load_makeups_members'};
            if (typeof data.responseJSON != 'undefined' && typeof data.responseJSON.error != 'undefined') {
                err.msg += ' : ' + data.responseJSON.error;
            }
            report_JS_error(err, 'orders');

            closeModal();
            alert('Erreur serveur lors de la récupération des membres avec rattrapage. Ré-essayez plus tard.');
        }
    });
}

/**
 * (Re)Display table of makeup members
 */
function display_makeups_members() {
    if (makeups_members_table) {
        $('#makeups_members_table').off();
        makeups_members_table.clear().destroy();
        $('#makeups_members_table').empty();
    }

    // Remove members with 0 makeups to do and 0 makeups to come
    ids_to_remove = [];
    for (let member_item of makeups_members) {
        if (member_item.makeups_to_do === 0 && member_item.makeups_to_come === 0) {
            ids_to_remove.push(member_item.id);
        }
    }
    makeups_members = makeups_members.filter(m => !ids_to_remove.includes(m.id));

    // TODO : select multiple and grouped action
    makeups_members_table = $('#makeups_members_table').DataTable({
        data: makeups_members,
        columns: [
            {
                data: "id",
                title: "",
                className: "dt-body-center",
                orderable: false,
                render: function (data, type, full) {
                    var html = ``;
                    if(full.shift_type == 'standard') { //prevent checking of ftop members so that they can't be target of makeup removal
                        html = `<input type="checkbox" class="select_member_cb" id="select_member_${data}" value="${data}">`;
                    }
                    return html;
                },
                width: "3%"
            },
            {
                data: "name",
                title: "Nom"
            },
            {
                data: "shift_type",
                title: "<div class='title_center'>Type de créneau</div>",
                className: "dt-body-center",
                width: "5%",
                render: function (data) {
                    if (data == 'ftop') {
                        return (has_committe_shift === "True") ? "Comités" : "Volant";
                    } else {
                        return 'ABCD';
                    }
                }
            },
            {
                data: "makeups_to_come",
                title: "<div class='title_center' title=\"Services de rattrapage déjà planifiés depuis l'espace membre.\">Déjà planifiés</div>",
                className: "dt-body-center",
                width: "8%",
                render: function (data, type, full) {
                    return `<b>${data}</b>`;
                }
            },
            {
                data: "makeups_to_do",
                title: "<div class='title_center' title=\"Rattrapages en attente de planification sur l'espace membre.\">A planifier</div>",
                className: "dt-body-center",
                width: "10%",
                render: function (data, type, full) {
                    var html = `<b>${data}</b>`
                    if(full.shift_type == 'standard') {
                        if(data > 0) {
                            html += `
                            <button class="decrement_makeup btn--primary" id="decrement_member_${full.id}">
                                <i class="fas fa-minus"></i>
                            </button>`;
                        }
                        html += `
                        <button class="increment_makeup btn--primary" id="increment_member_${full.id}">
                            <i class="fas fa-plus"></i>
                        </button>`;
                    }
                    return html;
                }
            },
            {
                data: "shift_type",
                title: "<div class='title_center' title=\"Le nombre de points est l'opposé du nombre total de rattrapages.\">Points</div>",
                className: "dt-body-center",
                width: "5%",
                render: function (data, type, row) {
                    if (data == 'ftop') {
                        return row.display_ftop_points;
                    } else if (data == 'standard') {
                        return row.display_std_points;
                    }

                    return null;
                }
            }
        ],
        aLengthMenu: [
            [
                25,
                50,
                -1
            ],
            [
                25,
                50,
                "Tout"
            ]
        ],
        iDisplayLength: 25,
        oLanguage: {
            "sProcessing":     "Traitement en cours...",
            "sSearch":         "Rechercher dans le tableau",
            "sLengthMenu":     "Afficher _MENU_ &eacute;l&eacute;ments",
            "sInfo":           "Affichage de l'&eacute;l&eacute;ment _START_ &agrave; _END_ sur _TOTAL_ &eacute;l&eacute;ments",
            "sInfoEmpty":      "Affichage de l'&eacute;l&eacute;ment 0 &agrave; 0 sur 0 &eacute;l&eacute;ment",
            "sInfoFiltered":   "(filtr&eacute; de _MAX_ &eacute;l&eacute;ments au total)",
            "sInfoPostFix":    "",
            "sLoadingRecords": "Chargement en cours...",
            "sZeroRecords":    "Aucun &eacute;l&eacute;ment &agrave; afficher",
            "sEmptyTable":     "Aucune donn&eacute;e disponible dans le tableau",
            "oPaginate": {
                "sFirst":      "Premier",
                "sPrevious":   "Pr&eacute;c&eacute;dent",
                "sNext":       "Suivant",
                "sLast":       "Dernier"
            },
            "oAria": {
                "sSortAscending":  ": activer pour trier la colonne par ordre croissant",
                "sSortDescending": ": activer pour trier la colonne par ordre d&eacute;croissant"
            },
            "select": {
                "rows": {
                    "_": "%d lignes séléctionnées",
                    "0": "Aucune ligne séléctionnée",
                    "1": "1 ligne séléctionnée"
                }
            }
        }
    });

    $('#makeups_members_table').on('click', 'tbody td .decrement_makeup', function () {
        const button_id = $(this).prop('id')
            .split('_');
        const member_id = button_id[button_id.length - 1];

        const member = makeups_members.find(m => m.id == member_id);

        let modal_template = $("#modal_decr_makeup_counter");

        modal_template.find(".member_name").text(member.name);

        openModal(
            modal_template.html(),
            () => {
                update_members_makeups(
                    [member_id],
                    "decrement",
                    ($("#decr-signature")[0].value || "auteur inconnu") + ' : ' + ($("#decr-explanation")[0].value || "pas d'explication")
                );
            },
            "Confirmer",
            false
        );
    });

    $('#makeups_members_table').on('click', 'tbody td .increment_makeup', function () {
        const button_id = $(this).prop('id')
            .split('_');
        const member_id = button_id[button_id.length - 1];

        const member = makeups_members.find(m => m.id == member_id);

        let modal_template = $("#modal_incr_makeup_counter");

        modal_template.find(".member_name").text(member.name);

        openModal(
            modal_template.html(),
            () => {
                update_members_makeups(
                    [member_id],
                    "increment",
                    ($("#incr-signature")[0].value || "auteur inconnu") + ' : ' + ($("#incr-explanation")[0].value || "pas d'explication")
                );
            },
            "Confirmer",
            false
        );
    });

    $('#makeups_members_table').on('click', 'tbody td .select_member_cb', function () {
        $(this).closest('tr')
            .toggleClass('selected');

        // Save / unsave selected row
        const m_id = makeups_members_table.row($(this).closest('tr')).data().id;
        const first_select = selected_rows.length === 0;

        if (this.checked) {
            selected_rows.push(m_id);
        } else {
            const i = selected_rows.findIndex(id => id == m_id);

            selected_rows.splice(i, 1);
        }

        if (selected_rows.length > 0) {
            $("#decrement_selected_members_makeups").show();
            if (first_select) {
                $("#decrement_selected_members_makeups").on("click", () => {
                    openModal(
                        $("#modal_decr_selected_makeup_counter").html(),
                        () => {
                            update_members_makeups(
                                selected_rows,
                                "decrement",
                                ($("#decr-signature-selected")[0].value || "auteur inconnu") + ' : ' + ($("#decr-explanation-selected")[0].value || "pas d'explication")
                            );
                        },
                        "Confirmer",
                        false
                    );
                });
            }
        } else {
            $("#decrement_selected_members_makeups").off()
                .hide();
        }
    });

    $('#makeups_members_table').on('click', 'tbody td .extend_delay_button', function () {
        const member_id = this.dataset.memberId;
        const member = makeups_members.find(m => m.id == member_id);

        let modal = $("#modal_extend_delay_template");

        modal.find(".member_name").text(member.name);

        openModal(
            modal.html(),
            () => {
                extend_member_delay(member);
            },
            "Confirmer",
            false
        );
    });
}

/**
 * Send request to update members nb of makeups to do
 *
 * @param {Array} member_ids
 * @param {String} action increment | decrement
 * @param description
 */
function update_members_makeups(member_ids, action, description) {
    openModal();

    data = [];
    for (mid of member_ids) {
        member_index = makeups_members.findIndex(m => m.id == mid);
        data.push({
            member_id: mid,
            target_makeups_nb: makeups_members[member_index].makeups_to_do + (action === 'increment' ? 1 : -1),
            member_shift_type: makeups_members[member_index].shift_type,
            display_ftop_points: makeups_members[member_index].display_ftop_points,
            display_std_points: makeups_members[member_index].display_std_points,
            description: description,
        });
    }

    $.ajax({
        type: 'POST',
        url: "/members/update_members_makeups",
        data: JSON.stringify(data),
        dataType:"json",
        traditional: true,
        contentType: "application/json; charset=utf-8",
        success: function(res) {
            selected_rows = [];
            for (element of res['res']) {
                member_index = makeups_members.findIndex(m => m.id == element['mid']);
                makeups_members[member_index].makeups_to_do += action === 'increment' ? 1 : -1
                makeups_members[member_index].display_std_points = element['standard_points']
            }
            display_makeups_members();
            closeModal();
        },
        error: function(data) {
            err = {msg: data.responseJSON.error, ctx: 'update_members_makeups'};
            report_JS_error(err, 'members_admin-manage_makeups');
            closeModal();
            alert(data.responseJSON.error);
        }
    });
}

/**
 * Display the members from the search result
 */
function display_possible_members() {
    $('.search_member_results_area').show();
    $('.search_member_results').empty();
    $('.btn_possible_member').off();

    let no_result = true;

    if (members_search_results.length > 0) {
        for (member of members_search_results) {
            // Don't display members already in the table
            if (makeups_members.find(m => m.id == member.id) != null) {
                continue;
            }

            $(".search_results_text").show();
            no_result = false;

            // Display results (possible members) as buttons
            var member_button = '<button class="btn--success btn_possible_member" member_id="'
                + member.id + '">'
                + member.barcode_base + ' - ' + member.name
                + '</button>';

            $('.search_member_results').append(member_button);

        }

        // Set action on member button click
        $('.btn_possible_member').on('click', function() {
            for (member of members_search_results) {
                if (member.id == $(this).attr('member_id')) {
                    if (makeups_members === null) {
                        makeups_members = [];
                    }

                    makeups_members.unshift({
                        id: member.id,
                        name: member.name,
                        makeups_to_do: 0,
                        shift_type: member.shift_type,
                        display_std_points: member.display_std_points,
                        display_ftop_points: member.display_ftop_points,
                        makeups_to_come: member.makeups_to_come
                    });

                    let modal_template = $("#modal_incr_makeup_counter");

                    modal_template.find(".member_name").text(member.name);

                    openModal(
                        modal_template.html(),
                        () => {
                            update_members_makeups(
                                [member.id],
                                "increment",
                                ($("#incr-signature")[0].value || "auteur inconnu") + ' : ' + ($("#incr-explanation")[0].value || "pas d'explication")
                            );
                            members_search_results = [];
                            $('#search_member_input').val('');
                            $('.search_member_results_area').hide();
                            $('.search_member_results').empty();
                        },
                        "Confirmer",
                        false
                    );

                    break;
                }
            }
        });
    }

    if (no_result === true) {
        $(".search_results_text").hide();
        $('.search_member_results').html(`<p>
            <i>Aucun résultat ! Vérifiez votre recherche, ou si le.la membre n'est pas déjà dans le tableau...</i>
        </p>`);
    }
}

$(document).ready(function() {
    if (coop_is_connected()) {
        $.ajaxSetup({ headers: { "X-CSRFToken": getCookie('csrftoken') } });

        $(".page_content").show();
        load_makeups_members();
    } else {
        $(".page_content").hide();
    }

    $('#back_to_admin_index').on('click', function() {
        let base_location = window.location.href.split("manage_makeups")[0].slice(0, -1);

        window.location.assign(base_location);
    });

    // Set action to search for the member
    $('#search_member_form').submit(function() {
        let search_str = $('#search_member_input').val();

        $.ajax({
            url: '/members/search/' + search_str +'?search_type=makeups_data',
            dataType : 'json',
            success: function(data) {
                members_search_results = [];
                members_search_results = data.res;

                display_possible_members();
            },
            error: function() {
                err = {
                    msg: "erreur serveur lors de la recherche de membres",
                    ctx: 'members.admin.manage_makeups.search_members'
                };
                report_JS_error(err, 'stock');

                $.notify("Erreur lors de la recherche de membre, il faut ré-essayer plus tard...", {
                    globalPosition:"top right",
                    className: "error"
                });
            }
        });
    });
});
