"""Company specific data values."""

"""Odoo coop specific constants ."""
COMPANY_LOGO = 'https://supercafoutch.fr/wp-content/uploads/2018/02/logo_SuperCafoutch_2021_500x225.png'
MAG_NAME = ''
OFFICE_NAME = ''
MAX_BEGIN_HOUR = '19:00'
COMPANY_NAME = 'SuperCafoutch'
WELCOME_ENTRANCE_MSG = 'Bienvenue à SuperCafoutch!'
WELCOME_MAIL_SUBJECT = 'Dernière étape de votre inscription à SuperCafoutch'
WELCOME_MAIL_TEMPLATE = 'members/bienvenue.html'
ENTRANCE_WITH_LATE_MODE = True
BLOCK_SERVICE_EXCHANGE_24H_BEFORE = True
DEFAULT_SHIFT_TYPE = 'standard'
SHOW_FTOP_BUTTON = True
USE_STANDARD_SHIFT = True
ENTRANCE_EXTRA_BUTTONS_DISPLAY = False
PREPA_ODOO_URL = '/members/prepa-odoo/'
BDM_SHOW_FTOP_BUTTON = True

EMAIL_DOMAIN = 'supercafoutch.fr'
CAP_JOURNAL_ID = 9
CAP_APPELE_NON_VERSE_ACCOUNT_ID = 529
CAP_APPELE_VERSE_ACCOUNT_ID = 8
CAP_INVOICE_LINE_ACCOUNT_ID = 7
FUNDRAISING_CAT_ID = 1
UNITE_UOM_ID = 1
PARTS_A_PRODUCT_ID = 5
PARTS_B_PRODUCT_ID = 6
PARTS_C_PRODUCT_ID = 7
PARTS_PRICE_UNIT = 10.0
PARTS_A_PRICE_UNIT = PARTS_PRICE_UNIT

EXPORT_COMPTA_FORMAT = 'Quadratus'

COOP_BARCODE_RULE_ID = 11
ASSOCIATE_BARCODE_RULE_ID = 12

CHECK_PAYMENT_ID = 8
VIREMENT_PAYMENT_ID = 16
CASH_PAYMENT_ID = 18
CB_PAYMENT_ID = 15
HELLO_ASSO_PAYMENT_ID = 29
SUMUP_PAYMENT_ID = 30

STOCK_LOC_ID = 12

CATEG_FRUIT = 151
CATEG_LEGUME = 152
FR_CATEGS = [CATEG_FRUIT]
VEG_CATEGS = [CATEG_LEGUME]
VRAC_CATEGS = [166, 167, 174, 179]
FLV_CSV_NB = 4


COEFF_MAG_ID = 1

DAV_PATH = '/shared_dir/dav'

RECEPTION_PDT_LABELS_FN = 'print_product_labels()'
RECEPTION_PDT_LABELS_TEXT = 'Cliquez sur ce bouton pour imprimer les étiquettes code-barres à coller sur les produits'
RECEPTION_PDT_LABELS_BTN_TEXT = 'Lancer l\'impression'
RECEPTION_SHELF_LABEL_PRINT = False
FIXED_BARCODE_PREFIX = '0491'
DISPLAY_COL_AUTRES = False
RECEPTION_ADD_ALL_LEFT_IS_GOOD_QTIES = True
RECEPTION_ADD_ALL_LEFT_IS_GOOD_PRICES = True
RECEPTION_ADD_PRODUCTS_PSWD = 'pass2makeApause'
RECEPTION_UPDATE_QTY_PSWD = 'pass2makeApause'
NO_BARCODE_MAIL_SUBJECT = " Articles sans codebarre de la commande : {}"
NO_BARCODE_MAIL_MSG = """
Bonjour {0},
    Vous avez crée la commande {1}, le {2}, pour {3}
    Voici la liste des codes barres qui manquent :
"""

ASSOCIATE_MEMBER_SHIFT = 585

SUBSCRIPTION_PAYMENT_MEANINGS = [
                                  {'code': 'cash', 'title': 'Espèces', 'journal_id': CASH_PAYMENT_ID},
                                  {'code': 'ch', 'title': 'Chèque', 'journal_id': CHECK_PAYMENT_ID},
                                  {'code': 'cb', 'title': 'Carte bancaire', 'journal_id': CB_PAYMENT_ID},
          {'code': 'vir', 'title': 'Virement', 'journal_id': VIREMENT_PAYMENT_ID},
          {'code': 'hel', 'title': 'HelloAsso', 'journal_id': HELLO_ASSO_PAYMENT_ID}
                                 ]


SHOP_HEADER_IMG = 'https://supercafoutch.fr/wp-content/uploads/2018/02/SC-logo-4-invert@1x.png'
SHOP_OPENING = {'jeu.': [{'start': '15:45', 'end': '18:15'}, {'start': '18:30', 'end': '21:00'}],
    'ven.': [{'start': '15:45', 'end': '18:15'}, {'start': '18:30', 'end': '21:00'}],
                'sam.': [{'start': '10:15', 'end': '12:45'}, {'start': '13:00', 'end': '15:30'}]}

SHOP_SLOT_SIZE = 15  #  minutes
SHOP_CATEGORIES = {
            'epicerie': {'id': 75, 'label': 'Epicerie'},
            'liquide': {'id': 96, 'label': 'Liquides'},
            'produits_frais': {'id': 104, 'label': 'Frais'},
            'surgeles': {'id': 115, 'label': 'Surgelés'},
            'bazar': {'id': 122, 'label': 'Bazar'},
            'droguerie': {'id': 127, 'label': 'Droguerie Hygiène'},
            'parfumerie': {'id': 133, 'label': 'Parfumerie'}
}

DELIVERY_CAN_BUY = True

EXCLUDE_SHOP_CATEGORIES=[]

DEFAULT_MAX_TIMESLOT_CARTS = 1
MIN_DELAY_FOR_SLOT = 0
HOURS_FOR_VALIDATION_SHOP = 2

SHOW_SUBSTITUTION_OPTION = False
CART_VALIDATION_BOTTOM_MSG = ""

SHOP_LIMIT_PRODUCTS = ['relatively_available', 'no_shelf']
VALIDATION_ORDER_MAIL_TEMPLATE = 'shop/supercafoutch_validation_mail.html'


ADMINS = ['francois@cooperatic.fr']
BRINKS_MUST_IDENTIFY = True
PROMOTE_SHELFS_IDS = []
DISCOUNT_SHELFS_IDS = []
FL_SHELFS = []
VRAC_SHELFS = []


SHIFT_INFO  = """Un service est une plage de trois heures un jour en particulier, par exemple : le mardi 25/09/2018 à 13h15.
<br />A l'inverse, un créneau est une plage de trois heures régulière, par exemple, tous les mardi de semaine A à 13h15."""
PB_INSTRUCTIONS = """Si j'ai un problème, que je suis désinscrit, que je veux changer de créneaux ou quoi que ce soit, merci de ..."""

ENTRANCE_COME_FOR_SHOPING_MSG = "Bienvenue dans ton magasin !"
#Regex stricte pour les numéros de téléphone français sur 10 chiffres
#et permissive pour les numéros commençant par + ou 00
INPUT_PHONE_PATTERN = "((\+|00)\d{5,30})|\d{10}"
CONFIRME_PRESENT_BTN = 'Clique ici pour valider ta présence'
ENTRANCE_WITH_LATE_MODE = True
# Members space / shifts
UNSUBSCRIBED_MSG = 'Vous êtes désincrit·e, merci de .....'
UNSUBSCRIBED_FORM_LINK = ''
SHIFT_EXCHANGE_DAYS_TO_HIDE = ''
ENTRANCE_VALIDATE_PRESENCE_MESSAGE = """
<div class="explanations">
 Ta présence a bien été validée !
</div>
Ton prochain service <span class="service_verb">est prévu</span> le <span class="next_shift"></span>
"""
SHOW_ABCD_CALENDAR_TAB = False
MEMBERS_SPACE_FAQ_TEMPLATE = None
MEMBERS_SPACE_HOME_TEMPLATE = 'members_space/supercafoutch/home.html'
MEMBERS_SPACE_SHOW_UNDERSTAND_MY_STATUS = False
BLOCK_ACTIONS_FOR_ATTACHED_PEOPLE = False
CAN_ADD_SHIFT = True

ALLOW_FOUR_DIGITS_IN_RECEPTION_PRICE = True

REMOVE_15_MINUTES_AT_SHIFT_END = False

# Fix incompatibility between meal voucher module and an old version of michel bibikoff product label printer software used in supercafoutch
SHOW_MEAL_VOUCHER_OK_LINE_IN_PRODUCT_INFO_FOR_LABEL = False

LOSSES_LOC_ID = 33
LOSSES_PICKING_TYPE_ID = 10
AUTOCONSO_LOC_ID = 27
AUTOCONSO_PICKING_TYPE_ID = 7

SUBSCRIPTION_ASK_FOR_SEX = True
SUBSCRIPTION_ASK_FOR_JOB = True

ALLOW_BOTH_AS_ANSWER_TO_WHO_IS_COMING_TO_SHIFT = False