function init_my_info() {
    init_my_info_data();

    $(".member_email").text(partner_data.email);

    if (partner_data.is_in_association === false) {
        $("#attached_info_area").hide();
    }

    if (partner_data.is_associated_people === "True") {
        $(".attached_partner_name").text(partner_data.parent_name);
    } else if (partner_data.associated_partner_id !== "False") {
        $(".attached_partner_name").text(partner_data.associated_partner_name);
    }

    $(".member_address").empty();
    if (partner_data.street !== "" && partner_data.street !== "False") {
        $(".member_address")
            .append(partner_data.street + "<br/>");
        if (partner_data.street2 !== "" && partner_data.street2 !== "False") {
            $(".member_address")
                .append(partner_data.street2 + "<br/>");
        }
        $(".member_address")
            .append(partner_data.zip + " " + partner_data.city);
    } else {
        $(".member_address_line").hide();
    }

    $(".member_mobile").empty();
    if (partner_data.mobile !== "" && partner_data.mobile !== "False" && partner_data.mobile !== false && partner_data.mobile !== null) {
        $(".member_mobile")
            .append(partner_data.mobile)
            .show();
    } else {
        $(".member_mobile").hide();
    }

    $(".member_phone").empty();
    if (partner_data.phone !== "" && partner_data.phone !== "False" && partner_data.phone !== false && partner_data.phone !== null) {
        $(".member_phone")
            .append(partner_data.phone)
            .show();
    } else {
        $(".member_phone").hide();
    }

    if ($(".member_mobile").text() === "" && $(".member_phone").text() === "") {
        $(".member_phone_line").hide();
    }

    $(".member_job").empty();
    if (partner_data.function !== "" && partner_data.function !== "False" && partner_data.function !== false && partner_data.function !== null) {
        $(".member_job")
            .append(partner_data.function)
            .show();
    } else {
        $(".member_job").hide();
    }

    if ($(".member_job").text() === "") {
        $(".member_job_line").hide();
    }

    $('#edit_address').off('click')
        .on('click', () => {
            $("#street_form").val(partner_data.street.replace(/&#39;/g, "'"));
            // $("#street2_form").val(partner_data.street2);
            $("#zip_form").val(partner_data.zip.replace(/&#39;/g, "'"));
            $("#city_form").val(partner_data.city.replace(/&#39;/g, "'"));
            $('#edit_address_value').hide();
            $('#edit_address_form').show();
        });
    $('#cancel_edit_address').
        on('click', () => {
            $('#edit_address_form').hide();
            $('#edit_address_value').show();
        });
    $('#save_edit_address').off('click')
        .on('click', () => {
            data= [];
            data['street']= $("#street_form").val();
            // data['street2']= $("#street2_form").val();
            data['zip']= $("#zip_form").val();
            data['city']= $("#city_form").val();

            saveInfo(data, 'address');
        });

    $('#edit_phone').off('click')
        .on('click', () => {
            if (partner_data.phone === "False") partner_data.phone = "";
            if (partner_data.mobile === "False") partner_data.mobile = "";
            $("#phone_form").val(partner_data.phone);
            $("#mobile_form").val(partner_data.mobile);
            $('#edit_phone_value').hide();
            $('#edit_phone_form').show();
        });
    $('#cancel_edit_phone').off('click')
        .on('click', () => {
            $('#edit_phone_form').hide();
            $('#edit_phone_value').show();
        });
    $('#save_edit_phone').off('click')
        .on('click', () => {
            data =[];
            data['phone']= $("#phone_form").val();
            data['mobile']= $("#mobile_form").val();
            saveInfo(data, 'phone');
        });
    $('#edit_job').off('click')
        .on('click', () => {
            if (partner_data.function === "False") partner_data.function = "";
            $("#job_form").val(partner_data.function);
            $('#edit_job_value').hide();
            $('#edit_job_form').show();
        });
    $('#cancel_edit_job').off('click')
        .on('click', () => {
            $('#edit_job_form').hide();
            $('#edit_job_value').show();
        });
    $('#save_edit_job').off('click')
        .on('click', () => {
            console.log('ici');
            data =[];
            data['function']= $("#job_form").val();
            saveInfo(data, 'function');
        });

}

function saveInfo(data, field) {
    tData = '&idPartner=' + partner_data.partner_id
    + '&shift_type=' + partner_data.shift_type
    + '&verif_token=' + partner_data.verif_token;
    for (d in data) {
        tData+="&"+d+"="+data[d];
    }

    tUrl = '/members/save_partner_info';
    $.ajax({
        type: 'POST',
        url: tUrl,
        dataType:"json",
        data: tData,
        timeout: 3000,
        success: function() {
            for (d in data) {
                partner_data[d]=data[d];
            }
            init_my_info();
            if (field == 'address') {
                $('#edit_address_form').hide();
                $('#edit_address_value').show();
            }
            if (field == 'phone') {
                $('#edit_phone_form').hide();
                $('#edit_phone_value').show();
            }
            if (field == 'function') {
                $('#edit_job_form').hide();
                $('#edit_job_value').show();
            }
        },
        error: function(error) {
            console.log(error);
        }
    });
}
